/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.store.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mingsoft.base.biz.SqlQueryWrapper;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.MapCacheUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.config.MSProperties;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ConfigEntity;
import net.mingsoft.mdiy.entity.DictEntity;
import net.mingsoft.mdiy.util.DictUtil;
import net.mingsoft.store.biz.IShareBiz;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="shareBizImpl")
@Transactional
public class ShareBizImpl
implements IShareBiz {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private net.mingsoft.mdiy.biz.IModelBiz modelBiz;
    @Autowired
    private IConfigBiz configBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @Override
    public String backup(String backDir) throws IOException {
        List modelEntities;
        LambdaQueryWrapper wrapper;
        String upload = MSProperties.upload.path;
        String template = MSProperties.upload.template;
        boolean enableWebsite = false;
        AppEntity app = BasicUtil.getWebsiteApp();
        if (app == null) {
            app = BasicUtil.getApp();
        } else {
            enableWebsite = true;
        }
        String appId = app.getId();
        String rootPath = BasicUtil.getRealPath((String)"/");
        if (!new File(backDir).isAbsolute()) {
            backDir = rootPath + File.separator + backDir;
        }
        String tmplBackDir = backDir;
        String tmplName = FileUtil.getName((String)backDir);
        File tmplFile = new File(rootPath + template + File.separator + appId + File.separator + tmplName);
        if (enableWebsite) {
            this.websiteExpTmpl(tmplFile.getPath());
        }
        FileUtil.copy((String)tmplFile.getPath(), (String)tmplBackDir, (boolean)true);
        boolean isCoOrGov = false;
        String whereCondition = enableWebsite ? " where APP_ID = " + appId : "";
        List contentList = this.modelBiz.queryForList("SELECT * FROM CMS_CONTENT" + whereCondition, new Object[0]);
        List categoryList = this.modelBiz.queryForList("SELECT * FROM CMS_CATEGORY" + whereCondition, new Object[0]);
        List appMap = this.modelBiz.queryForList("SELECT APP_NAME,APP_LOGO,APP_KEYWORD,APP_COPYRIGHT,APP_STYLE,APP_DESCRIPTION FROM APP" + (enableWebsite ? " where id = " + appId : ""), new Object[0]);
        StringBuilder modelAndFormDataJson = new StringBuilder();
        ArrayList contentIgnoreMapList = new ArrayList();
        for (Object map : contentList) {
            TreeMap caseInsensitiveMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            BeanUtil.copyProperties((Object)map, caseInsensitiveMap, (String[])new String[0]);
            contentIgnoreMapList.add(caseInsensitiveMap);
        }
        ArrayList categoryIgnoreMapList = new ArrayList();
        for (Map map : categoryList) {
            TreeMap caseInsensitiveMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            BeanUtil.copyProperties((Object)map, caseInsensitiveMap, (String[])new String[0]);
            categoryIgnoreMapList.add(caseInsensitiveMap);
        }
        if (enableWebsite) {
            contentIgnoreMapList.forEach(contentMap -> contentMap.remove("app_id"));
            categoryIgnoreMapList.forEach(categoryMap -> categoryMap.remove("app_id"));
            wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"APP_ID", (Object)appId)).ne((Object)"MODEL_TYPE", (Object)"people")).and(wrapper1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper1.eq((Object)"MODEL_CUSTOM_TYPE", (Object)"form")).or()).eq((Object)"MODEL_CUSTOM_TYPE", (Object)"model")).or()).eq((Object)"MODEL_CUSTOM_TYPE", (Object)"tag");
            });
            modelEntities = this.modelBiz.list((Wrapper)wrapper);
            modelEntities.forEach(modelEntity -> {
                if (!ModelCustomTypeEnum.TAG.getLabel().equals(modelEntity.getModelCustomType())) {
                    String modelTableName = modelEntity.getModelTableName();
                    modelEntity.setModelTableName(modelTableName.replace("_" + appId, ""));
                    ModelJsonBean modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
                    modelJsonBean.setTableName(modelJsonBean.getTableName().replace("_" + appId, ""));
                    String siteTableName = modelTableName.replace("MDIY_FORM_", "{model}").replace("MDIY_MODEL_", "{model}");
                    String tableName = siteTableName.replace("_" + appId, "");
                    modelJsonBean.setSql(modelJsonBean.getSql().replace(siteTableName, tableName));
                    modelEntity.setModelJson(JSONUtil.toJsonStr((Object)modelJsonBean));
                }
            });
        } else {
            wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.ne(net.mingsoft.mdiy.entity.ModelEntity::getModelType, (Object)"people")).and(wrapper1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(net.mingsoft.mdiy.entity.ModelEntity::getModelCustomType, (Object)"form")).or()).eq(net.mingsoft.mdiy.entity.ModelEntity::getModelCustomType, (Object)"model")).or()).eq(net.mingsoft.mdiy.entity.ModelEntity::getModelCustomType, (Object)"tag");
            });
            modelEntities = this.modelBiz.list((Wrapper)wrapper);
        }
        List dictEntities = DictUtil.list((String)"\u6a21\u677f\u7c7b\u578b");
        if (CollectionUtil.isNotEmpty((Collection)dictEntities)) {
            isCoOrGov = true;
            contentIgnoreMapList.forEach(content -> {
                content.remove("PROGRESS_STATUS");
                content.remove("CONTENT_TITLE_CSS");
                content.remove("CONTENT_STYLE");
                content.remove("ORGANIZATION_ID");
                content.remove("CATEGORY_IDS");
                content.remove("PROGRESS_DESC");
            });
            categoryIgnoreMapList.forEach(category -> {
                String categoryUrls = category.get("CATEGORY_URLS").toString();
                List categoryUrlsMap = JSONUtil.toList((String)categoryUrls, Map.class);
                String categoryListUrls = category.get("CATEGORY_LIST_URLS").toString();
                List categoryListUrlsMap = JSONUtil.toList((String)categoryListUrls, Map.class);
                categoryListUrlsMap.forEach(categoryListUrl -> {
                    if (((DictEntity)dictEntities.get(0)).getDictLabel().equals(categoryListUrl.get("name").toString())) {
                        category.put("CATEGORY_LIST_URL", categoryListUrl.get("file"));
                    }
                });
                category.remove("CATEGORY_LIST_URLS");
                categoryUrlsMap.forEach(categoryUrl -> {
                    if (((DictEntity)dictEntities.get(0)).getDictLabel().equals(categoryUrl.get("name").toString())) {
                        category.put("CATEGORY_URL", categoryUrl.get("file"));
                    }
                });
                category.remove("CATEGORY_URLS");
            });
            Map appData = (Map)appMap.get(0);
            appData.remove("APP_STYLES");
            appData.put("APP_STYLE", tmplName);
            this.coOrGovTmplExp(tmplBackDir);
        }
        String appInfo = JSONUtil.toJsonStr(appMap.get(0));
        String contents = JSONUtil.toJsonStr(contentIgnoreMapList);
        String categories = JSONUtil.toJsonStr(categoryIgnoreMapList);
        FileUtil.writeString((String)appInfo, (String)(tmplBackDir + "/data/APP.json"), (Charset)StandardCharsets.UTF_8);
        FileUtil.writeString((String)contents, (String)(tmplBackDir + "/data/CMS_CONTENT.json"), (Charset)StandardCharsets.UTF_8);
        FileUtil.writeString((String)categories, (String)(tmplBackDir + "/data/CMS_CATEGORY.json"), (Charset)StandardCharsets.UTF_8);
        String tableNameSuffix = enableWebsite ? "_" + appId : "";
        JSONConfig jsonConfig = JSONConfig.create().setDateFormat("yyyy-MM-dd HH:mm:ss");
        modelEntities.forEach(modelEntity -> {
            String modelEntityJson = JSONUtil.toJsonStr((Object)modelEntity);
            if (modelEntity.getModelCustomType().equals("tag")) {
                List tagDataList = this.modelBiz.queryForList("SELECT MODEL_ID, CONFIG_NAME, CONFIG_DATA, CONFIG_TYPE FROM MDIY_CONFIG WHERE model_id = ?", new Object[]{modelEntity.getId()});
                List tagList = this.modelBiz.queryForList("SELECT tag_name, tag_type, tag_sql, tag_class, tag_description, MODEL_ID FROM MDIY_TAG WHERE model_id = ?", new Object[]{modelEntity.getId()});
                FileUtil.writeString((String)JSONUtil.toJsonStr((Object)tagDataList, (JSONConfig)jsonConfig), (String)(tmplBackDir + "/data/TAG_DATA_JSON_" + modelEntity.getModelName() + ".json"), (Charset)StandardCharsets.UTF_8);
                modelAndFormDataJson.append(JSONUtil.toJsonStr((Object)tagDataList));
                FileUtil.writeString((String)JSONUtil.toJsonStr((Object)tagList), (String)(tmplBackDir + "/data/TAG_JSON_" + modelEntity.getModelName() + ".json"), (Charset)StandardCharsets.UTF_8);
                FileUtil.writeString((String)modelEntityJson, (String)(tmplBackDir + "/data/MODEL_JSON_TAG_" + modelEntity.getModelName() + ".json"), (Charset)StandardCharsets.UTF_8);
            } else {
                String modelDataTableName = modelEntity.getModelTableName() + tableNameSuffix;
                List modelData = this.modelBiz.queryForList("select * from " + modelDataTableName, new Object[0]);
                String modelDataJson = JSONUtil.toJsonStr((Object)modelData, (JSONConfig)jsonConfig);
                modelAndFormDataJson.append(modelDataJson);
                FileUtil.writeString((String)modelDataJson, (String)(tmplBackDir + "/data/DATA_MODEL_JSON_" + modelEntity.getModelTableName() + ".json"), (Charset)StandardCharsets.UTF_8);
                FileUtil.writeString((String)modelEntityJson, (String)(tmplBackDir + "/data/MODEL_JSON_" + modelEntity.getModelTableName() + ".json"), (Charset)StandardCharsets.UTF_8);
            }
        });
        File tmplUploadFile = FileUtil.isAbsolutePath((String)upload) ? new File(File.separator + upload + File.separator + appId) : new File(rootPath + File.separator + upload + File.separator + appId);
        if (tmplUploadFile.exists()) {
            String group1;
            HashSet<String> usedRes = new HashSet<String>();
            StringBuilder picImages = new StringBuilder();
            StringBuilder detailImages = new StringBuilder();
            for (Map map : contentIgnoreMapList) {
                picImages.append(map.get("content_img"));
                detailImages.append(map.get("content_details"));
            }
            for (Map map : categoryIgnoreMapList) {
                picImages.append(map.get("category_img")).append(map.get("category_ico"));
            }
            picImages.append(app.getAppLogo());
            picImages.append((CharSequence)modelAndFormDataJson);
            Pattern imgPattern = Pattern.compile("\"url\".*?/upload/" + appId + "(.*?)\"");
            Matcher imgMatcher = imgPattern.matcher(picImages);
            while (imgMatcher.find()) {
                group1 = imgMatcher.group(1);
                usedRes.add(group1);
            }
            detailImages.append((CharSequence)modelAndFormDataJson);
            imgPattern = Pattern.compile("['\"]/upload/" + appId + "(.*?)['\"]");
            imgMatcher = imgPattern.matcher(detailImages);
            while (imgMatcher.find()) {
                group1 = imgMatcher.group(1);
                usedRes.add(group1);
            }
            String targetUploadPath = tmplBackDir + "/data/upload";
            File file = new File(targetUploadPath);
            if (file.exists()) {
                FileUtil.del((File)file);
            }
            if (file.mkdirs()) {
                for (String usedImg : usedRes) {
                    File sourceFile = new File(tmplUploadFile.getPath() + usedImg);
                    if (!sourceFile.exists()) continue;
                    File targetFile = new File(file, usedImg);
                    FileUtil.copy((File)sourceFile, (File)targetFile, (boolean)true);
                }
            } else {
                this.LOG.debug("\u5bfc\u51faupload\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff0c\u76ee\u6807upload\u521b\u5efa\u5730\u5740: {}\uff0c\u8bf7\u5220\u9664\u8be5\u76ee\u5f55\u540e\u91cd\u65b0\u5bfc\u51fa", (Object)targetUploadPath);
                throw new BusinessException("\u5bfc\u51faupload\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff0c\u76ee\u6807upload\u521b\u5efa\u5730\u5740\uff0c\u8bf7\u5220\u9664\u8be5\u76ee\u5f55\u540e\u91cd\u65b0\u5bfc\u51fa: " + targetUploadPath);
            }
        }
        String html = MSProperties.diy.htmlDir;
        if (StringUtils.isNotBlank((CharSequence)app.getAppDir())) {
            if (isCoOrGov) {
                FileUtil.copy((String)(rootPath + html + File.separator + app.getAppDir() + File.separator + tmplName), (String)(tmplBackDir + File.separator + "html"), (boolean)true);
            } else {
                FileUtil.copy((String)(rootPath + html + File.separator + app.getAppDir()), (String)(tmplBackDir + File.separator + "html"), (boolean)true);
            }
        } else if (isCoOrGov) {
            FileUtil.copy((String)(rootPath + html + File.separator + tmplName), (String)(tmplBackDir + File.separator + "html"), (boolean)true);
        } else {
            FileUtil.copy((String)(rootPath + html), (String)tmplBackDir, (boolean)true);
        }
        this.htmlReplace(tmplBackDir + File.separator + "html", template, appId);
        File zipFile = ZipUtil.zip((String)tmplBackDir);
        FileUtil.del((String)tmplBackDir);
        return zipFile.getPath();
    }

    @Override
    public void tmplUnZip(String appId, String tmplName) {
        this.importData(appId, tmplName);
    }

    @Override
    public void tmplUnZip(String tmplName) {
        this.delData();
        this.importData(null, tmplName);
    }

    private void importData(String appId, String tmplName) {
        String template = MSProperties.upload.template;
        String upload = MSProperties.upload.path;
        String rootPath = BasicUtil.getRealPath((String)"/");
        if (appId == null) {
            appId = BasicUtil.getApp().getId();
        }
        String tmplDir = rootPath + File.separator + template + File.separator + appId + File.separator + tmplName;
        this.impHandleCssAndHtml(tmplDir);
        File dataUploadFile = new File(tmplDir + "/data/upload/");
        ArrayList<String> uploadDirFileNames = new ArrayList<String>();
        File[] files = dataUploadFile.listFiles();
        File fileParam = FileUtil.isAbsolutePath((String)upload) ? new File(upload + File.separator + appId) : new File(BasicUtil.getRealPath((String)(upload + File.separator + appId)));
        for (File file : files) {
            if (!(file.getName().equals("cms") || file.getName().equals("appLogo") || file.getName().matches("[\\d]+"))) {
                uploadDirFileNames.add(file.getName());
            }
            FileUtil.copy((File)file, (File)fileParam, (boolean)true);
        }
        this.saveData(uploadDirFileNames, tmplDir, appId);
        FileUtil.del((String)(tmplDir + "/data"));
    }

    private void saveData(List<String> uploadDirFileNames, String tmplDir, String appId) {
        String categoryJson = this.impHandleJsonData(uploadDirFileNames, tmplDir, "CMS_CATEGORY.json", appId);
        String contentJson = this.impHandleJsonData(uploadDirFileNames, tmplDir, "CMS_CONTENT.json", appId);
        String appJson = this.impHandleJsonData(uploadDirFileNames, tmplDir, "APP.json", appId);
        HashMap<String, Long> categoryIds = new HashMap<String, Long>();
        HashMap<String, Long> contentIds = new HashMap<String, Long>();
        boolean isCoOrGov = false;
        List dictEntities = DictUtil.list((String)"\u6a21\u677f\u7c7b\u578b");
        if (CollectionUtil.isNotEmpty((Collection)dictEntities)) {
            isCoOrGov = true;
        }
        List categories = JSONUtil.toList((String)categoryJson, TreeMap.class);
        ArrayList categoryListTreeMap = new ArrayList();
        categories.forEach(category -> {
            TreeMap categoryTreeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            BeanUtil.copyProperties((Object)category, categoryTreeMap, (String[])new String[0]);
            categoryListTreeMap.add(categoryTreeMap);
        });
        List contents = JSONUtil.toList((String)contentJson, TreeMap.class);
        ArrayList contentListTreeMap = new ArrayList();
        contents.forEach(content -> {
            TreeMap contentTreeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            BeanUtil.copyProperties((Object)content, contentTreeMap, (String[])new String[0]);
            contentListTreeMap.add(contentTreeMap);
        });
        TreeMap appMap = (TreeMap)JSONUtil.toBean((String)appJson, TreeMap.class);
        TreeMap appMapTreeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        TreeMap treeMap = (TreeMap)JSONUtil.toBean((String)appJson, TreeMap.class);
        BeanUtil.copyProperties((Object)treeMap, appMapTreeMap, (String[])new String[0]);
        String appStyle = appMap.get("APP_STYLE").toString();
        if (isCoOrGov) {
            ArrayList appStyles = new ArrayList();
            appMap.put("APP_STYLE", "");
            for (int i = 0; i < dictEntities.size(); ++i) {
                HashMap<String, String> style = new HashMap<String, String>();
                style.put("name", ((DictEntity)dictEntities.get(i)).getDictLabel());
                if (i == 0) {
                    style.put("template", appStyle);
                } else {
                    style.put("template", "");
                }
                appStyles.add(style);
            }
            appMap.put("app_styles", JSONUtil.toJsonStr(appStyles));
            categoryListTreeMap.forEach(category -> {
                ArrayList categoryUrlList = new ArrayList();
                ArrayList categoryListUrlList = new ArrayList();
                String categoryUrl = "";
                String categoryListUrl = "";
                if (!Objects.isNull(category.get("category_url"))) {
                    categoryUrl = category.get("category_url").toString();
                }
                if (!Objects.isNull(category.get("category_list_url"))) {
                    categoryListUrl = category.get("category_list_url").toString();
                }
                for (int i = 0; i < dictEntities.size(); ++i) {
                    HashMap<String, String> categoryUrls = new HashMap<String, String>();
                    HashMap<String, String> categoryListUrls = new HashMap<String, String>();
                    categoryUrls.put("name", ((DictEntity)dictEntities.get(i)).getDictLabel());
                    categoryListUrls.put("name", ((DictEntity)dictEntities.get(i)).getDictLabel());
                    if (i == 0) {
                        categoryUrls.put("template", appStyle);
                        categoryUrls.put("file", categoryUrl);
                        categoryListUrls.put("template", appStyle);
                        categoryListUrls.put("file", categoryListUrl);
                    } else {
                        categoryUrls.put("template", "");
                        categoryUrls.put("file", "");
                        categoryListUrls.put("template", "");
                        categoryListUrls.put("file", "");
                    }
                    categoryUrlList.add(categoryUrls);
                    categoryListUrlList.add(categoryListUrls);
                }
                category.put("category_url", "");
                category.put("category_urls", JSONUtil.toJsonStr(categoryUrlList));
                category.put("category_list_url", "");
                category.put("category_list_urls", JSONUtil.toJsonStr(categoryListUrlList));
            });
            contentListTreeMap.forEach(content -> {
                content.put("progress_status", "\u7ec8\u5ba1\u901a\u8fc7");
                content.put("content_style", ((DictEntity)dictEntities.get(0)).getDictValue());
                content.put("content_title_css", "color:;");
            });
        }
        appMap.put("id", appId);
        appMap.put("APP_URL", BasicUtil.getUrl());
        HashMap<String, String> whereMap = new HashMap<String, String>();
        whereMap.put("id", appId);
        this.modelBiz.update("APP", (Map)appMap, whereMap);
        IAppBiz appBiz = (IAppBiz)SpringUtil.getBean(IAppBiz.class);
        MapCacheUtil.remove((String)BasicUtil.getDomain());
        appBiz.updateCache();
        Snowflake snowflake = IdUtil.getSnowflake();
        for (Map category2 : categoryListTreeMap) {
            long snowId = snowflake.nextId();
            categoryIds.put(category2.get("id").toString(), snowId);
        }
        for (Map category2 : categoryListTreeMap) {
            category2.put("create_date", DateTime.of((long)((Long)category2.get("create_date"))));
            category2.put("update_date", DateTime.of((long)((Long)category2.get("update_date"))));
            if (Objects.isNull(category2.get("category_display"))) {
                category2.put("category_display", "enable");
            }
            category2.put("id", categoryIds.get(String.valueOf(category2.get("id"))));
            if (categoryIds.containsKey(String.valueOf(category2.get("top_id")))) {
                category2.put("top_id", categoryIds.get(String.valueOf(category2.get("top_id"))));
            } else {
                category2.put("top_id", "0");
            }
            category2.put("category_id", categoryIds.get(String.valueOf(category2.get("category_id"))));
            Object parentIds = category2.get("category_parent_ids");
            if (parentIds != null && !"".equals(parentIds)) {
                String[] ids = parentIds.toString().split(",");
                List list = Arrays.stream(ids).map(id -> (Long)categoryIds.get(id)).collect(Collectors.toList());
                category2.put("category_parent_ids", StrUtil.join((CharSequence)",", list));
            }
            this.LOG.debug("\u5f53\u524d\u680f\u76ee\u6570\u636e: {}", (Object)category2.toString());
            if (BasicUtil.getWebsiteApp() != null && BasicUtil.getWebsiteApp().getId().equals(appId)) {
                category2.put("app_id", appId);
            }
            this.modelBiz.insert("CMS_CATEGORY", category2);
        }
        int i = 0;
        for (Map content2 : contentListTreeMap) {
            long snowId = snowflake.nextId();
            contentIds.put(content2.get("id").toString(), snowId);
            content2.put("id", snowId);
            content2.put("category_id", categoryIds.get(String.valueOf(content2.get("category_id"))));
            content2.put("content_datetime", DateTime.of((long)(System.currentTimeMillis() + (long)i * 1000L)));
            content2.put("update_date", new Date());
            content2.put("create_date", new Date());
            if (BasicUtil.getWebsiteApp() != null && BasicUtil.getWebsiteApp().getId().equals(appId)) {
                content2.put("app_id", appId);
            }
            this.modelBiz.insert("CMS_CONTENT", content2);
            ++i;
        }
        this.handleMdiyData(tmplDir, categoryIds, contentIds, appId);
        this.templateIdReplace(tmplDir, categoryIds, contentIds, uploadDirFileNames);
    }

    private void executeMdiyInsertSql(net.mingsoft.mdiy.entity.ModelEntity model, Map params) {
        SqlInjectionUtil.filterContent((String[])new String[]{model.getModelTableName()});
        CaseInsensitiveMap fieldMap = new CaseInsensitiveMap(model.getFieldMap());
        params = new CaseInsensitiveMap(params);
        List fieldList = JSONUtil.toList((String)model.getModelField(), Map.class);
        ArrayList<Object> param = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(model.getModelTableName()).append(" (");
        StringBuilder values = new StringBuilder();
        Set paramKeys = Collections.unmodifiableSet(new HashSet(params.keySet()));
        String fieldName = "";
        String type = "";
        String value = "";
        for (Map map : fieldList) {
            fieldName = MapUtil.getStr((Map)map, (Object)"key").toLowerCase();
            if (!paramKeys.contains(fieldName)) continue;
            type = MapUtil.getStr((Map)map, (Object)"type", (String)"String");
            if ("date".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type)) {
                value = new SqlQueryWrapper().handleTime(type);
                sql.append(fieldName).append(", ");
                values.append(value).append(", ");
                param.add(params.get(fieldName));
                continue;
            }
            sql.append(fieldName).append(", ");
            values.append("?, ");
            param.add(params.get(fieldName));
        }
        if (StrUtil.isNotBlank((CharSequence)MapUtil.getStr((Map)params, (Object)"LINK_ID"))) {
            sql.append("LINK_ID, ");
            values.append("?, ");
            param.add(MapUtil.getStr((Map)params, (Object)"LINK_ID"));
        }
        if (StrUtil.isNotBlank((CharSequence)MapUtil.getStr((Map)params, (Object)"CREATE_BY"))) {
            sql.append("CREATE_BY, ");
            values.append("?, ");
            param.add(BasicUtil.getManager().getId());
        }
        sql.append("CREATE_DATE, ");
        values.append("?, ");
        if (StrUtil.isNotBlank((CharSequence)MapUtil.getStr((Map)params, (Object)"CREATE_DATE"))) {
            param.add(MapUtil.getStr((Map)params, (Object)"CREATE_DATE"));
        } else {
            param.add(new Date());
        }
        sql.append("UPDATE_DATE");
        values.append("?");
        if (StrUtil.isNotBlank((CharSequence)MapUtil.getStr((Map)params, (Object)"UPDATE_DATE"))) {
            param.add(MapUtil.getStr((Map)params, (Object)"UPDATE_DATE"));
        } else {
            param.add(new Date());
        }
        sql.append(") VALUES (");
        sql.append((CharSequence)values).append(")");
        this.modelBiz.update(sql.toString(), param.toArray());
    }

    private void delData() {
        List modelEntityList;
        QueryWrapper wrapper;
        AppEntity app = BasicUtil.getWebsiteApp();
        if (app == null) {
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u6587\u7ae0\u8868\u6570\u636e...");
            this.modelBiz.execute("DELETE FROM cms_content");
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u680f\u76ee\u8868\u6570\u636e...");
            this.modelBiz.execute("DELETE FROM cms_category");
            wrapper = new QueryWrapper();
            wrapper.and(wrapper1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper1.eq((Object)"MODEL_CUSTOM_TYPE", (Object)ModelCustomTypeEnum.FORM.getLabel())).or()).eq((Object)"MODEL_CUSTOM_TYPE", (Object)ModelCustomTypeEnum.MODEL.getLabel())).or()).eq((Object)"MODEL_CUSTOM_TYPE", (Object)ModelCustomTypeEnum.TAG.getLabel());
            });
            modelEntityList = this.modelBiz.list((Wrapper)wrapper);
        } else {
            app = BasicUtil.getApp();
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u7ad9\u70b9{}\u6587\u7ae0\u8868\u6570\u636e...", (Object)app.getAppId());
            this.modelBiz.execute("DELETE FROM cms_content WHERE APP_ID = " + app.getId());
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u7ad9\u70b9{}\u680f\u76ee\u8868\u6570\u636e...", (Object)app.getAppId());
            this.modelBiz.execute("DELETE FROM cms_category WHERE APP_ID = " + app.getId());
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u7ad9\u70b9{}\u81ea\u5b9a\u4e49\u6a21\u578b\u548c\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6570\u636e...", (Object)app.getAppId());
            wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"APP_ID", (Object)app.getAppId())).and(wrapper1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper1.eq((Object)"MODEL_CUSTOM_TYPE", (Object)ModelCustomTypeEnum.FORM.getLabel())).or()).eq((Object)"MODEL_CUSTOM_TYPE", (Object)ModelCustomTypeEnum.MODEL.getLabel())).or()).eq((Object)"MODEL_CUSTOM_TYPE", (Object)ModelCustomTypeEnum.TAG.getLabel());
            });
            modelEntityList = this.modelBiz.list((Wrapper)wrapper);
        }
        List modelIds = modelEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.modelBiz.delete(modelIds);
        if (CollUtil.isNotEmpty(modelIds)) {
            this.configBiz.remove((Wrapper)new LambdaQueryWrapper().in(ConfigEntity::getModelId, modelIds));
        }
        List tagModelIds = modelEntityList.stream().filter(modelEntity -> ModelCustomTypeEnum.TAG.getLabel().equals(modelEntity.getModelCustomType())).map(modelEntity -> modelEntity.getId()).collect(Collectors.toList());
        this.modelBiz.update("DELETE  FROM  MDIY_TAG WHERE MODEL_ID IN ( ? ) ", new Object[]{String.join((CharSequence)",", tagModelIds)});
        IModelBiz menuModelBiz = (IModelBiz)SpringUtil.getBean(IModelBiz.class);
        int[] ids = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)menuModelBiz.lambdaQuery().eq(ModelEntity::getModelTitle, (Object)"\u81ea\u5b9a\u4e49\u5168\u5c40\u53c2\u6570")).eq(app != null, ModelEntity::getAppId, (Object)app.getAppId())).list().stream().map(ModelEntity::getId).mapToInt(Integer::parseInt).toArray();
        menuModelBiz.delete(ids);
        String upload = MSProperties.upload.path;
        this.LOG.debug("\u5f00\u59cb\u5220\u9664upload\u8d44\u6e90...");
        if (FileUtil.isAbsolutePath((String)upload)) {
            FileUtil.del((String)(upload + "/" + BasicUtil.getApp().getId()));
        } else {
            String rootPath = BasicUtil.getRealPath((String)"/");
            FileUtil.del((String)(rootPath + upload + "/" + BasicUtil.getApp().getId()));
        }
    }

    private void impHandleCssAndHtml(String tmplFilePath) {
        List tmplDirFiles = FileUtil.loopFiles((String)tmplFilePath);
        tmplDirFiles.forEach(file -> {
            if ("css".equals(FileUtil.extName((File)file))) {
                String cssContent = FileUtil.readString((File)file, (Charset)StandardCharsets.UTF_8);
                cssContent = cssContent.replaceAll("url\\(/upload/1", "url(../images");
                cssContent = cssContent.replaceAll("url\\(\"/upload/1", "url(\"../images");
                cssContent = cssContent.replaceAll("url\\(/upload", "url(../images");
                cssContent = cssContent.replaceAll("url\\(\"/upload", "url(\"../images");
                FileUtil.writeString((String)cssContent, (File)file, (Charset)StandardCharsets.UTF_8);
            }
        });
    }

    private String impHandleJsonData(List<String> uploadDirFileNames, String tmplDir, String jsonName, String appId) {
        String jsonStr = FileUtil.readString((String)(tmplDir + "/data/" + jsonName), (Charset)StandardCharsets.UTF_8);
        for (String uploadDirFileName : uploadDirFileNames) {
            jsonStr = jsonStr.replaceAll("/upload/" + uploadDirFileName, "/upload/" + appId + "/" + uploadDirFileName);
        }
        jsonStr = jsonStr.replaceAll("/upload/[\\d]+/", "/upload/" + appId + "/");
        return jsonStr;
    }

    private void handleMdiyData(String tmplDir, Map<String, Long> categoryIds, Map<String, Long> contentIds, String appId) {
        File dataFile = new File(tmplDir + "/data");
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        String modelTableNameSuffix = "";
        if (websiteApp != null) {
            modelTableNameSuffix = "_" + websiteApp.getAppId();
        }
        File[] mdiyModelJsons = dataFile.listFiles(pathname -> pathname.getName().startsWith("MODEL_JSON"));
        ArrayList<String> tableNames = new ArrayList<String>();
        for (File mdiyModelJson : mdiyModelJsons) {
            net.mingsoft.mdiy.entity.ModelEntity mdiyModelEntity;
            String modelEntityJson = FileUtil.readString((String)mdiyModelJson.getPath(), (Charset)StandardCharsets.UTF_8);
            net.mingsoft.mdiy.entity.ModelEntity modelEntity = (net.mingsoft.mdiy.entity.ModelEntity)JSONUtil.toBean((String)modelEntityJson, net.mingsoft.mdiy.entity.ModelEntity.class);
            String modelJson = modelEntity.getModelJson();
            ModelJsonBean modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelJson, ModelJsonBean.class);
            modelJsonBean.setTableName(modelJsonBean.getTableName());
            modelJsonBean.setTitle(modelEntity.getModelName());
            modelJsonBean.setField(modelEntity.getModelField());
            try {
                if (ModelCustomTypeEnum.TAG.getLabel().equalsIgnoreCase(modelEntity.getModelCustomType()) ? !this.configBiz.importConfig(modelEntity.getModelCustomType(), modelJsonBean) : !this.modelBiz.importModel(modelEntity.getModelCustomType(), modelJsonBean, modelEntity.getModelType())) {
                    throw new BusinessException("\u5bfc\u5165" + modelEntity.getModelName() + "\u6a21\u578b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5728\u81ea\u5b9a\u4e49\u6a21\u5757\u662f\u5426\u6709\u91cd\u590d\u540d\u79f0");
                }
            }
            catch (BusinessException e) {
                for (String tableName : tableNames) {
                    this.modelBiz.execute("DROP TABLE " + tableName);
                }
                throw new BusinessException("\u5bfc\u5165" + modelEntity.getModelName() + "\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5728\u81ea\u5b9a\u4e49\u6a21\u5757\u662f\u5426\u6709\u91cd\u590d\u540d\u79f0");
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            File mdiyModelDataFile = new File(dataFile, "DATA_" + mdiyModelJson.getName());
            String modelDataJson = !mdiyModelDataFile.exists() ? "[]" : FileUtil.readString((String)mdiyModelDataFile.getPath(), (Charset)StandardCharsets.UTF_8);
            modelDataJson = modelDataJson.replaceAll("/upload/[\\d]+/", "/upload/" + appId + "/");
            String tableName = modelEntity.getModelTableName() + modelTableNameSuffix;
            if (ModelCustomTypeEnum.MODEL.getLabel().equals(modelEntity.getModelCustomType())) {
                tableNames.add(tableName);
                wrapper.eq(net.mingsoft.mdiy.entity.ModelEntity::getModelTableName, (Object)("MDIY_MODEL_" + modelJsonBean.getTableName()));
                mdiyModelEntity = (net.mingsoft.mdiy.entity.ModelEntity)this.modelBiz.getOne((Wrapper)wrapper);
                String mdiyModelEntityId = mdiyModelEntity.getId();
                String whereCondition = "cms".equals(modelEntity.getModelType()) ? "MDIY_MODEL_ID" : "MDIY_CATEGORY_MODEL_ID";
                List categoryMaps = this.modelBiz.queryForList(StrUtil.format((CharSequence)("SELECT * FROM CMS_CATEGORY WHERE " + whereCondition + " = " + modelEntity.getId()), (Object[])new Object[0]), new Object[0]);
                if (CollectionUtil.isNotEmpty((Collection)categoryMaps)) {
                    for (Map categoryMap : categoryMaps) {
                        Iterator fieldsMap = new HashMap();
                        fieldsMap.put(whereCondition, mdiyModelEntityId);
                        HashMap whereMap = new HashMap();
                        whereMap.put("id", categoryMap.get("id"));
                        this.modelBiz.update("CMS_CATEGORY", fieldsMap, whereMap);
                    }
                }
                Map<String, Long> curModelReplaceId = "cms".equals(modelEntity.getModelType()) ? contentIds : categoryIds;
                List modelDataMaps = JSONUtil.toList((String)modelDataJson, Map.class);
                for (Map modelDataMap : modelDataMaps) {
                    modelDataMap.put("LINK_ID", curModelReplaceId.get(modelDataMap.get("LINK_ID").toString()));
                    this.executeMdiyInsertSql(mdiyModelEntity, modelDataMap);
                }
                continue;
            }
            if (ModelCustomTypeEnum.TAG.getLabel().equals(modelEntity.getModelCustomType())) {
                ((LambdaQueryWrapper)wrapper.eq(net.mingsoft.mdiy.entity.ModelEntity::getModelCustomType, (Object)ModelCustomTypeEnum.TAG.getLabel())).eq(net.mingsoft.mdiy.entity.ModelEntity::getModelName, (Object)modelJsonBean.getTitle());
                mdiyModelEntity = (net.mingsoft.mdiy.entity.ModelEntity)this.modelBiz.getOne((Wrapper)wrapper);
                File tagFile = new File(dataFile, "TAG_JSON_" + modelJsonBean.getTitle());
                String tagJson = FileUtil.readString((String)(tagFile.getPath() + ".json"), (Charset)StandardCharsets.UTF_8);
                List tagList = JSONUtil.toList((String)tagJson, Map.class);
                for (Map map : tagList) {
                    map.put("MODEL_ID", mdiyModelEntity.getId());
                    if (websiteApp != null) {
                        map.put("APP_ID", websiteApp.getId());
                    } else {
                        map.remove("APP_ID");
                    }
                    this.modelBiz.insert("MDIY_TAG", map);
                }
                File tagDataFile = new File(dataFile, "TAG_DATA_JSON_" + modelJsonBean.getTitle());
                String tagDataJson = FileUtil.readString((String)(tagDataFile.getPath() + ".json"), (Charset)StandardCharsets.UTF_8);
                tagList = JSONUtil.toList((String)tagDataJson, Map.class);
                for (Map map : tagList) {
                    map.put("MODEL_ID", mdiyModelEntity.getId());
                    HashMap<String, String> whereField = new HashMap<String, String>();
                    whereField.put("MODEL_ID", mdiyModelEntity.getId());
                    if (websiteApp != null) {
                        map.put("APP_ID", websiteApp.getId());
                    } else {
                        map.remove("APP_ID");
                    }
                    this.modelBiz.update("MDIY_CONFIG", map, whereField);
                }
                String globalTagjson = "[{\"createBy\":\"\",\"createDate\":null,\"del\":0,\"id\":\"1821\",\"remarks\":null,\"updateBy\":\"57\",\"updateDate\":\"2024-11-26 09:25:22\",\"order\":null,\"modelTitle\":\"\u81ea\u5b9a\u4e49\u5168\u5c40\u53c2\u6570\",\"modelDatetime\":1732584270000,\"modelId\":84,\"modelUrl\":\"mdiy/tag/globalTag/config.do?modelId=1860892324126367745&isEditor=true\",\"modelCode\":\"\",\"isChild\":\"\",\"modelIcon\":\"\",\"modelSort\":0,\"modelChildList\":[{\"createBy\":null,\"createDate\":null,\"del\":0,\"id\":\"1825\",\"remarks\":null,\"updateBy\":null,\"updateDate\":null,\"order\":null,\"modelTitle\":\"\u914d\u7f6e\",\"modelDatetime\":1732584270000,\"modelId\":1821,\"modelUrl\":\"mdiy:tag:config\",\"modelCode\":null,\"isChild\":null,\"modelIcon\":null,\"modelSort\":0,\"modelChildList\":null,\"modelIsMenu\":0,\"chick\":0,\"depth\":2,\"modelParentIds\":\"84,1821\"},{\"createBy\":null,\"createDate\":null,\"del\":0,\"id\":\"1824\",\"remarks\":null,\"updateBy\":null,\"updateDate\":null,\"order\":null,\"modelTitle\":\"\u67e5\u770b\",\"modelDatetime\":1732584270000,\"modelId\":1821,\"modelUrl\":\"mdiy:tag:view\",\"modelCode\":null,\"isChild\":null,\"modelIcon\":null,\"modelSort\":0,\"modelChildList\":null,\"modelIsMenu\":0,\"chick\":0,\"depth\":2,\"modelParentIds\":\"84,1821\"},{\"createBy\":null,\"createDate\":null,\"del\":0,\"id\":\"1823\",\"remarks\":null,\"updateBy\":null,\"updateDate\":null,\"order\":null,\"modelTitle\":\"\u7f16\u8f91\",\"modelDatetime\":1732584270000,\"modelId\":1821,\"modelUrl\":\"mdiy:tag:update\",\"modelCode\":null,\"isChild\":null,\"modelIcon\":null,\"modelSort\":0,\"modelChildList\":null,\"modelIsMenu\":0,\"chick\":0,\"depth\":2,\"modelParentIds\":\"84,1821\"},{\"createBy\":null,\"createDate\":null,\"del\":0,\"id\":\"1822\",\"remarks\":null,\"updateBy\":null,\"updateDate\":null,\"order\":null,\"modelTitle\":\"\u65b0\u589e\",\"modelDatetime\":1732584270000,\"modelId\":1821,\"modelUrl\":\"mdiy:tag:save\",\"modelCode\":null,\"isChild\":null,\"modelIcon\":null,\"modelSort\":0,\"modelChildList\":null,\"modelIsMenu\":0,\"chick\":0,\"depth\":2,\"modelParentIds\":\"84,1821\"}],\"modelIsMenu\":1,\"chick\":0,\"depth\":1,\"modelParentIds\":\"84\"}]";
                List modelEntityList = JSONUtil.toList((String)globalTagjson, ModelEntity.class);
                IModelBiz menuModelBiz = (IModelBiz)SpringUtil.getBean(IModelBiz.class);
                List TagMenuList = ((LambdaQueryChainWrapper)menuModelBiz.lambdaQuery().eq(ModelEntity::getModelTitle, (Object)"\u81ea\u5b9a\u4e49\u6807\u7b7e")).list();
                if (!CollUtil.isEmpty((Collection)TagMenuList)) continue;
                for (ModelEntity model : modelEntityList) {
                    if (model.getModelIsMenu() != 1) continue;
                    model.setModelUrl(StrFormatter.format((String)"mdiy/tag/globalTag/config.do?modelId={}&isEditor=true", (Object[])new Object[]{mdiyModelEntity.getId()}));
                    if (websiteApp != null) {
                        model.setAppId(appId);
                    }
                    menuModelBiz.importModel(model, BasicUtil.getManager().getRoleId(), "84", Integer.valueOf(84));
                }
                continue;
            }
            tableNames.add(tableName);
            wrapper.eq(net.mingsoft.mdiy.entity.ModelEntity::getModelTableName, (Object)("MDIY_FORM_" + modelJsonBean.getTableName()));
            mdiyModelEntity = (net.mingsoft.mdiy.entity.ModelEntity)this.modelBiz.getOne((Wrapper)wrapper);
            List mdiyFormDataMaps = JSONUtil.toList((String)modelDataJson, Map.class);
            for (Map mdiyFormDataMap : mdiyFormDataMaps) {
                this.executeMdiyInsertSql(mdiyModelEntity, mdiyFormDataMap);
            }
        }
    }

    private void htmlReplace(String htmlFilePath, String template, String appId) {
        File html = new File(htmlFilePath);
        File[] htmlFiles = html.listFiles();
        String appUrl = BasicUtil.getApp().getAppUrl();
        for (File htmlFile : htmlFiles) {
            if (htmlFile.isDirectory()) {
                this.htmlReplace(htmlFile.getPath(), template, appId);
                continue;
            }
            String htmlContent = FileUtil.readString((File)htmlFile, (Charset)StandardCharsets.UTF_8);
            htmlContent = htmlContent.replaceAll(appUrl + "//", "/");
            htmlContent = htmlContent.replaceAll(appUrl + "/", "/");
            htmlContent = htmlContent.replaceAll(appUrl, "/");
            htmlContent = htmlContent.replaceAll("/" + template + "/" + appId, "");
            htmlContent = htmlContent.replaceAll("upload/" + appId, "upload");
            FileUtil.writeString((String)htmlContent, (File)htmlFile, (Charset)StandardCharsets.UTF_8);
        }
    }

    private void templateIdReplace(String templatePath, Map<String, Long> categoryIds, Map<String, Long> contentIds, List<String> uploadDirFileNames) {
        categoryIds.put("0", 0L);
        List templateFiles = FileUtil.loopFiles((String)templatePath, file -> FileUtil.extName((File)file).equals("html") || FileUtil.extName((File)file).equals("htm"));
        templateFiles.forEach(templateFile -> {
            List fileLines = FileUtil.readLines((File)templateFile, (Charset)StandardCharsets.UTF_8);
            String line = "";
            String newFile = "";
            Iterator linesIterator = fileLines.iterator();
            String appId = BasicUtil.getApp().getId();
            while (linesIterator.hasNext()) {
                boolean findTypeids;
                boolean findForm;
                boolean dataId;
                Pattern tmplListPattern;
                Matcher matcher;
                boolean typeId;
                line = (String)linesIterator.next();
                if (CollectionUtil.isNotEmpty((Collection)uploadDirFileNames)) {
                    for (String uploadDirFileName : uploadDirFileNames) {
                        line = line.replaceAll("upload/" + uploadDirFileName, "upload/" + appId + "/" + uploadDirFileName);
                    }
                } else {
                    line = line.replaceAll("upload/[\\d]+/", "upload/" + appId + "/");
                }
                if (typeId = (matcher = (tmplListPattern = Pattern.compile("typeid[\\s]?=[\\s]?([\"|'])?([\\d]+)([\"|']?)")).matcher(line)).find()) {
                    String categoryId = "";
                    if (Objects.nonNull(categoryIds.get(matcher.group(2)))) {
                        categoryId = ((Long)categoryIds.get(matcher.group(2))).toString();
                    } else {
                        this.LOG.debug("\u7ad9\u70b9{} \u680f\u76eeid{}\u66ff\u6362\u5f02\u5e38", (Object)appId, (Object)matcher.group(2));
                    }
                    String newLine = matcher.replaceAll("typeid=\"" + categoryId + "\"");
                    newFile = newFile + newLine + "\n";
                }
                if (dataId = (matcher = (tmplListPattern = Pattern.compile("dataid[\\s]?=[\\s]?([\"|'])?([\\d]+)([\"|']?)")).matcher(line)).find()) {
                    String contentId = "";
                    if (Objects.nonNull(contentIds.get(matcher.group(2)))) {
                        contentId = ((Long)contentIds.get(matcher.group(2))).toString();
                    } else {
                        this.LOG.debug("\u7ad9\u70b9{} \u6587\u7ae0id{}\u66ff\u6362\u5f02\u5e38", (Object)appId, (Object)matcher.group(2));
                    }
                    String newLine = matcher.replaceAll("dataid=\"" + contentId + "\"");
                    newFile = newFile + newLine + "\n";
                }
                if (findForm = (matcher = (tmplListPattern = Pattern.compile("value=\\D?([\\d,+]*)\\D?[\\s\\S]*name=\\S?categoryIds\\S?")).matcher(line)).find()) {
                    String inputCategoryIds;
                    String oldIds = inputCategoryIds = matcher.group(1);
                    if (StringUtils.isNotBlank((CharSequence)inputCategoryIds) && inputCategoryIds.contains(",")) {
                        String[] categoryIdArr;
                        StringBuilder newCategoryIds = new StringBuilder();
                        for (String s : categoryIdArr = inputCategoryIds.split(",")) {
                            if (StringUtils.isNotBlank((CharSequence)newCategoryIds)) {
                                newCategoryIds.append(",");
                            }
                            if (Objects.nonNull(categoryIds.get(s))) {
                                newCategoryIds.append(categoryIds.get(s));
                                continue;
                            }
                            this.LOG.debug("\u7ad9\u70b9{} \u66ff\u6362\u641c\u7d22\u680f\u76eecategoryIds\u4e2d\u7684{}\u5f02\u5e38", (Object)appId, (Object)s);
                        }
                        inputCategoryIds = newCategoryIds.toString();
                    } else if (Objects.nonNull(categoryIds.get(inputCategoryIds))) {
                        inputCategoryIds = ((Long)categoryIds.get(inputCategoryIds)).toString();
                    } else {
                        this.LOG.debug("\u7ad9\u70b9{} \u66ff\u6362\u641c\u7d22\u680f\u76eecategoryIds\u4e2d\u7684{}\u5f02\u5e38", (Object)appId, (Object)inputCategoryIds);
                    }
                    String group = matcher.group();
                    group = group.replace(oldIds, inputCategoryIds);
                    String newLine = matcher.replaceAll(group);
                    newFile = newFile + newLine + "\n";
                }
                if (findTypeids = (matcher = (tmplListPattern = Pattern.compile("typeids=(.*['\"]?)}")).matcher(line)).find()) {
                    String oldTypeids = matcher.group(1);
                    String standardOldTypeIds = oldTypeids.replaceAll("['\"]", "");
                    String[] typeidArray = standardOldTypeIds.split(",");
                    String newTypeids = oldTypeids.replaceAll("\\d+", "{}");
                    for (String typeid : typeidArray) {
                        newTypeids = StrUtil.format((CharSequence)newTypeids, (Object[])new Object[]{((Long)categoryIds.get(typeid)).toString()});
                    }
                    String group = matcher.group();
                    group = group.replace(oldTypeids, newTypeids);
                    String newLine = matcher.replaceAll(group);
                    newFile = newFile + newLine + "\n";
                }
                if (typeId || dataId || findForm || findTypeids) continue;
                newFile = newFile + line + "\n";
            }
            FileUtil.writeString((String)newFile, (File)templateFile, (Charset)StandardCharsets.UTF_8);
        });
    }

    private void isCoOrGovTagReplace(String templatePath) {
        List templateFiles = FileUtil.loopFiles((String)templatePath, file -> FileUtil.extName((File)file).equals("html") || FileUtil.extName((File)file).equals("htm"));
        templateFiles.forEach(templateFile -> {
            String fileContent = FileUtil.readString((File)templateFile, (Charset)StandardCharsets.UTF_8);
            fileContent = fileContent.replaceAll("\\{ms:global.html/}", "{ms:global.html/}/{ms:global.template/}");
            FileUtil.writeString((String)fileContent, (File)templateFile, (Charset)StandardCharsets.UTF_8);
        });
    }

    private void coOrGovTmplExp(String templatePath) {
        List templateFiles = FileUtil.loopFiles((String)templatePath, file -> FileUtil.extName((File)file).equals("html") || FileUtil.extName((File)file).equals("htm"));
        templateFiles.forEach(templateFile -> {
            String fileContent = FileUtil.readString((File)templateFile, (Charset)StandardCharsets.UTF_8);
            FileUtil.writeString((String)fileContent, (File)templateFile, (Charset)StandardCharsets.UTF_8);
        });
    }

    private void websiteExpTmpl(String templatePath) {
        List templateFiles = FileUtil.loopFiles((String)templatePath, file -> FileUtil.extName((File)file).equals("html") || FileUtil.extName((File)file).equals("htm"));
        templateFiles.forEach(templateFile -> {
            List fileLines = FileUtil.readLines((File)templateFile, (Charset)StandardCharsets.UTF_8);
            String line2 = "";
            String newFile = "";
            for (String line2 : fileLines) {
                Pattern pattern = Pattern.compile("tableName.*=\"(([\\s\\S]*?)\\d+)\"");
                Matcher matcher = pattern.matcher(line2);
                boolean model = matcher.find();
                if (model) {
                    String newLine = matcher.replaceAll("tableName=\"" + matcher.group(2) + "\"");
                    newFile = newFile + newLine + "\n";
                }
                if (model) continue;
                newFile = newFile + line2 + "\n";
            }
            FileUtil.writeString((String)newFile, (File)templateFile, (Charset)StandardCharsets.UTF_8);
        });
    }
}

