/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions.traverse;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minidev.json.actions.path.PathDelimiter;
import net.minidev.json.actions.traverse.TreeTraverseAction;

public class TreeTraverser<M extends Map<String, Object>, L extends List<Object>> {
    protected TreeTraverseAction<M, L> action;
    protected PathDelimiter delim;
    protected String pathPrefix = "";

    public TreeTraverser(TreeTraverseAction action, PathDelimiter delim) {
        this.action = action;
        this.delim = delim;
    }

    public TreeTraverser with(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }

    public void traverse(M map) {
        if (this.action.start(map)) {
            this.depthFirst(this.pathPrefix, (L)map);
        }
        this.action.end();
    }

    private void depthFirst(String fullPath, M map) {
        if (map == null || map.entrySet() == null || !this.action.recurInto(fullPath, map)) {
            return;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String fullPathToEntry = this.buildPath(fullPath, (String)entry.getKey());
            if (!this.action.traverseEntry(fullPathToEntry, entry)) continue;
            if (this.action.removeEntry(fullPathToEntry, entry)) {
                it.remove();
                continue;
            }
            if (entry.getValue() instanceof Map) {
                this.depthFirst(fullPathToEntry, (L)((Map)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof List) {
                this.depthFirst(fullPathToEntry, (L)((List)entry.getValue()));
                continue;
            }
            this.action.handleLeaf(fullPathToEntry, entry);
        }
    }

    private void depthFirst(String fullPath, L list) {
        if (!this.action.recurInto(fullPath, list)) {
            return;
        }
        int listIndex = 0;
        Object[] objectArray = list.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listItem = objectArray[n2];
            if (listItem instanceof Map) {
                this.depthFirst(fullPath, (L)((Map)listItem));
            } else if (listItem instanceof List) {
                this.depthFirst(fullPath, (L)((List)listItem));
            } else {
                this.action.handleLeaf(fullPath, listIndex, listItem);
            }
            ++listIndex;
            ++n2;
        }
    }

    private String buildPath(String fullPath, String entryKey) {
        return this.pathPrefix.equals(fullPath) ? String.valueOf(this.pathPrefix) + entryKey : String.valueOf(fullPath) + this.delim.str() + entryKey;
    }
}

