/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.actions.path.DotDelimiter;
import net.minidev.json.actions.path.PathDelimiter;
import net.minidev.json.actions.traverse.JSONTraverser;
import net.minidev.json.actions.traverse.LocatePathsJsonAction;
import net.minidev.json.actions.traverse.RetainPathsJsonAction;

public class PathsRetainer {
    protected List<String> pathsToRetain;
    protected PathDelimiter pathDelimiter = new DotDelimiter().withAcceptDelimiterInNodeName(false);

    public PathsRetainer(JSONArray pathsToRetain) {
        if (pathsToRetain == null || pathsToRetain.isEmpty()) {
            this.pathsToRetain = Collections.emptyList();
        } else {
            this.pathsToRetain = new LinkedList<String>();
            for (Object s : pathsToRetain) {
                this.pathsToRetain.add((String)s);
            }
        }
    }

    public PathsRetainer(List<String> pathsToRetain) {
        this.pathsToRetain = pathsToRetain == null || pathsToRetain.size() == 0 ? Collections.emptyList() : pathsToRetain;
    }

    public PathsRetainer(String ... pathsToRetain) {
        this.pathsToRetain = pathsToRetain == null || pathsToRetain.length == 0 ? Collections.emptyList() : new LinkedList<String>(Arrays.asList(pathsToRetain));
    }

    public PathsRetainer with(PathDelimiter pathDelimiter) {
        this.pathDelimiter = pathDelimiter;
        return this;
    }

    public JSONObject retain(JSONObject object) {
        LocatePathsJsonAction locateAction = new LocatePathsJsonAction(this.pathsToRetain, this.pathDelimiter);
        JSONTraverser t1 = new JSONTraverser(locateAction);
        t1.traverse(object);
        List realPathsToRetain = (List)locateAction.result();
        RetainPathsJsonAction retainer = new RetainPathsJsonAction(realPathsToRetain, this.pathDelimiter);
        JSONTraverser t2 = new JSONTraverser(retainer).with(this.pathDelimiter);
        t2.traverse(object);
        return (JSONObject)retainer.result();
    }
}

