/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStreamAware;
import net.minidev.json.JStylerObj;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.JSONParserStream;
import net.minidev.json.parser.ParseException;

public class JSONValue {
    public static Object parse(Reader in) {
        try {
            return new JSONParserStream().parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(String s) {
        try {
            return new JSONParser().parse(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        return new JSONParserStream().parse(in, ContainerFactory.FACTORY);
    }

    public static Object parseWithException(String s) throws ParseException {
        return new JSONParser().parse(s, ContainerFactory.FACTORY);
    }

    public static void writeJSONString(Object value, Appendable out) throws IOException {
        if (value == null) {
            out.append("null");
            return;
        }
        if (value instanceof String) {
            out.append('\"');
            JSONValue.escape((String)value, out);
            out.append('\"');
            return;
        }
        if (value instanceof Number) {
            if (value instanceof Double) {
                if (((Double)value).isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            } else if (value instanceof Float) {
                if (((Float)value).isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            } else {
                out.append(value.toString());
            }
            return;
        }
        if (value instanceof Boolean) {
            out.append(value.toString());
        } else if (value instanceof JSONStreamAware) {
            ((JSONStreamAware)value).writeJSONString(out);
        } else if (value instanceof JSONAware) {
            out.append(((JSONAware)value).toJSONString());
        } else if (value instanceof Map) {
            JSONObject.writeJSONString((Map)value, out);
        } else if (value instanceof List) {
            JSONArray.writeJSONString((List)value, out);
        } else {
            out.append('\"');
            out.append(JSONValue.escape(value.toString()));
            out.append('\"');
        }
    }

    public static String toJSONString(Object value) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONValue.writeJSONString(value, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JStylerObj.escape(s, sb);
        return sb.toString();
    }

    public static void escape(String s, Appendable ap) {
        if (s == null) {
            return;
        }
        JStylerObj.escape(s, ap);
    }
}

