package net.minidev.json.parser;

import java.io.IOException;

import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;

public class ContentHandlerCompressor implements ContentHandler {
	Appendable out;
	JSONStyle compression;
	
	int[] stack = new int[10];
	int pos;
	// push 0 = < Object
	// push 1 = < Array
	private void push(int type) {
		pos += 2;
		if (pos >= stack.length) {
			int[] tmp = new int[stack.length * 2];
			System.arraycopy(stack, 0, tmp, 0, stack.length);
			stack = tmp;
		}
		stack[pos] = type;
		stack[pos+1] = 0;
	}
	private boolean isInObject() {
		return stack[pos] == 0;
	}
	
//	Stack<JsonStructure> stack = new Stack<ContentHandlerCompressor.JsonStructure>();
//	private static class JsonStructure {
//		public byte type;
//		public int size = 0;
//
//		private JsonStructure(byte type) {
//			this.type = type;
//		}
//
//		static JsonStructure newArray() {
//			return new JsonStructure((byte) 2);
//		}
//
//		static JsonStructure newObj() {
//			return new JsonStructure((byte) 1);
//		}
//
//		public boolean isObj() {
//			return type == (byte) 1;
//		}
//	}

	public ContentHandlerCompressor(Appendable out, JSONStyle compression) {
		this.out = out;
		this.compression = compression;
	}

	@Override
	public void startJSON() throws ParseException, IOException {
	}

	@Override
	public void endJSON() throws ParseException, IOException {
	}

	@Override
	public boolean startObject() throws ParseException, IOException {
		out.append('{');
		push(0);
//		stack.add(JsonStructure.newObj());
		return false;
	}

	@Override
	public boolean endObject() throws ParseException, IOException {
		out.append('}');
		pos-=2;
//		stack.pop();
		return false;
	}

	@Override
	public boolean startObjectEntry(String key) throws ParseException, IOException {
		if (stack[pos+1]++ > 0)
			out.append(',');
		if (key == null)
			out.append("null");
		else if (!compression.mustProtectKey(key))
			out.append(key);
		else {
			out.append('"');
			JSONValue.escape(key, out, compression);
			out.append('"');
		}
		out.append(':');
		return false;
	}

	@Override
	public boolean endObjectEntry() throws ParseException, IOException {
		return false;
	}

	@Override
	public boolean startArray() throws ParseException, IOException {
		out.append('[');
		push(1);
//		stack.add(JsonStructure.newArray());
		return false;
	}

	@Override
	public boolean endArray() throws ParseException, IOException {
		out.append(']');
		pos-=2;
		return false;
	}

	@Override
	public boolean primitive(Object value) throws ParseException, IOException {
		if (!isInObject() && stack[pos+1]++ > 0)
				out.append(',');

		if (value instanceof String) {
			if (!compression.mustProtectValue((String) value))
				out.append((String) value);
			else {
				out.append('"');
				JSONValue.escape((String) value, out, compression);
				out.append('"');
			}
		} else
			JSONValue.writeJSONString(value, out, compression);
		return false;
	}
}
