/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ContentHandlerDumy;
import net.minidev.json.parser.JSONBaseParser;
import net.minidev.json.parser.ParseException;

class JSONStringParser
extends JSONBaseParser {
    public static final byte EOI = 26;
    private char c;
    private String in;
    private int len;

    public JSONStringParser(int permissiveMode) {
        super(permissiveMode);
    }

    public Object parse(String in) throws ParseException {
        return this.parse(in, ContainerFactory.FACTORY_SIMPLE, ContentHandlerDumy.HANDLER);
    }

    public Object parse(String in, ContainerFactory containerFactory) throws ParseException {
        return this.parse(in, containerFactory, ContentHandlerDumy.HANDLER);
    }

    public Object parse(String in, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        Object result;
        this.len = in.length();
        this.in = in;
        this.containerFactory = containerFactory;
        this.handler = handler;
        this.pos = -1;
        try {
            this.read();
            handler.startJSON();
            result = this.readMain(stopX);
            handler.endJSON();
        }
        catch (IOException e) {
            throw new ParseException(this.pos, (Throwable)e);
        }
        this.xs = null;
        this.xo = null;
        return result;
    }

    private final void read() {
        this.c = ++this.pos >= this.len ? (char)26 : this.in.charAt(this.pos);
    }

    private final void readNoEnd() throws ParseException {
        if (++this.pos >= this.len) {
            this.c = (char)26;
            throw new ParseException(this.pos - 1, 3, "EOF");
        }
        this.c = this.in.charAt(this.pos);
    }

    private List<Object> readArray() throws ParseException, IOException {
        List<Object> obj = this.containerFactory.createArrayContainer();
        if (this.c != '[') {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        boolean needData = false;
        this.handler.startArray();
        block7: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block7;
                }
                case ']': {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    this.handler.endArray();
                    return obj;
                }
                case ':': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case ',': {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    needData = true;
                    continue block7;
                }
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, "EOF");
                }
            }
            obj.add(this.readMain(stopArray));
            needData = false;
        }
    }

    private Object readMain(boolean[] stop) throws ParseException, IOException {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '{': {
                    return this.readObject();
                }
                case '[': {
                    return this.readArray();
                }
                case '\"': 
                case '\'': {
                    this.xs = this.readString();
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'n': {
                    this.xs = this.readNQString(stop);
                    if ("null".equals(this.xs)) {
                        this.handler.primitive(null);
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'f': {
                    this.xs = this.readNQString(stop);
                    if ("false".equals(this.xs)) {
                        this.handler.primitive(Boolean.FALSE);
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 't': {
                    this.xs = this.readNQString(stop);
                    if ("true".equals(this.xs)) {
                        this.handler.primitive(Boolean.TRUE);
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'N': {
                    this.xs = this.readNQString(stop);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        this.handler.primitive(Float.valueOf(Float.NaN));
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.xo = this.readNumber(stop);
                    this.handler.primitive(this.xo);
                    return this.xo;
                }
            }
            break;
        }
        this.xs = this.readNQString(stop);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        this.handler.primitive(this.xs);
        return this.xs;
    }

    private String readNQString(boolean[] stop) {
        int start = this.pos;
        this.skipNQString(stop);
        return this.in.substring(start, this.pos).trim();
    }

    private Object readNumber(boolean[] stop) throws ParseException {
        int start = this.pos;
        this.read();
        this.skipDigits();
        if (this.c != '.' && this.c != 'E' && this.c != 'e') {
            this.skipSpace();
            if (this.c >= '\u0000' && this.c < '~' && !stop[this.c] && this.c != '\u001a') {
                this.skipNQString(stop);
                this.xs = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.xs = this.in.substring(start, this.pos).trim();
            return this.parseNumber(this.xs);
        }
        if (this.c == '.') {
            this.read();
            this.skipDigits();
        }
        if (this.c != 'E' && this.c != 'e') {
            this.skipSpace();
            if (this.c >= '\u0000' && this.c < '~' && !stop[this.c] && this.c != '\u001a') {
                this.skipNQString(stop);
                this.xs = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.xs = this.in.substring(start, this.pos).trim();
            if (!this.acceptLeadinZero) {
                this.checkLeadinZero();
            }
            if (!this.useHiPrecisionFloat) {
                return Float.valueOf(Float.parseFloat(this.xs));
            }
            if (this.xs.length() > 18) {
                return new BigDecimal(this.xs);
            }
            return Double.parseDouble(this.xs);
        }
        this.sb.append('E');
        this.read();
        if (this.c == '+' || this.c == '-' || this.c >= '0' && this.c <= '9') {
            this.sb.append(this.c);
            this.read();
            this.skipDigits();
            this.skipSpace();
            if (this.c >= '\u0000' && this.c < '~' && !stop[this.c] && this.c != '\u001a') {
                this.skipNQString(stop);
                this.xs = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.xs = this.in.substring(start, this.pos).trim();
            if (!this.useHiPrecisionFloat) {
                return Float.valueOf(Float.parseFloat(this.xs));
            }
            return Double.parseDouble(this.xs);
        }
        this.skipNQString(stop);
        this.xs = this.in.substring(start, this.pos).trim();
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        if (!this.acceptLeadinZero) {
            this.checkLeadinZero();
        }
        return this.xs;
    }

    private Map<String, Object> readObject() throws ParseException, IOException {
        Map<String, Object> obj = this.containerFactory.createObjectContainer();
        if (this.c != '{') {
            throw new RuntimeException("Internal Error");
        }
        this.handler.startObject();
        boolean needData = false;
        boolean acceptData = true;
        block6: while (true) {
            String key;
            this.read();
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                case ':': 
                case '[': 
                case ']': 
                case '{': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '}': {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    this.handler.endObject();
                    return obj;
                }
                case ',': {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    needData = true;
                    acceptData = true;
                    continue block6;
                }
            }
            int keyStart = this.pos;
            if (this.c == '\"' || this.c == '\'') {
                key = this.readString();
            } else {
                key = this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, key);
                }
            }
            if (!acceptData) {
                throw new ParseException(this.pos, 1, key);
            }
            this.handler.startObjectEntry(key);
            while (this.c != ':' && this.c != '\u001a') {
                this.read();
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos - 1, 3, null);
            }
            this.readNoEnd();
            Object duplicate = obj.put(key, this.readMain(stopValue));
            if (duplicate != null) {
                throw new ParseException(keyStart, 5, key);
            }
            this.handler.endObjectEntry();
            if (this.c == '}') {
                this.read();
                this.handler.endObject();
                return obj;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos - 1, 3, null);
            }
            if (this.c == ',') {
                needData = true;
                acceptData = true;
                continue;
            }
            needData = false;
            acceptData = false;
        }
    }

    private String readString() throws ParseException, IOException {
        if (!this.acceptSimpleQuote && this.c == '\'') {
            if (this.acceptNonQuote) {
                return this.readNQString(stopAll);
            }
            throw new ParseException(this.pos, 0, Character.valueOf(this.c));
        }
        int tmpP = this.in.indexOf(this.c, this.pos + 1);
        if (tmpP == -1) {
            throw new ParseException(this.in.length(), 3, null);
        }
        this.xs = this.in.substring(this.pos + 1, tmpP);
        if (this.xs.indexOf(92) == -1) {
            this.checkControleChar();
            this.pos = tmpP;
            this.read();
            return this.xs;
        }
        this.sb.clear();
        char sep = this.c;
        block18: while (true) {
            this.read();
            switch (this.c) {
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case '\"': 
                case '\'': {
                    if (sep == this.c) {
                        this.read();
                        return this.sb.toString();
                    }
                    this.sb.append(this.c);
                    continue block18;
                }
                case '\\': {
                    this.read();
                    switch (this.c) {
                        case 't': {
                            this.sb.append('\t');
                            continue block18;
                        }
                        case 'n': {
                            this.sb.append('\n');
                            continue block18;
                        }
                        case 'r': {
                            this.sb.append('\r');
                            continue block18;
                        }
                        case 'f': {
                            this.sb.append('\f');
                            continue block18;
                        }
                        case 'b': {
                            this.sb.append('\b');
                            continue block18;
                        }
                        case '\\': {
                            this.sb.append('\\');
                            continue block18;
                        }
                        case '/': {
                            this.sb.append('/');
                            continue block18;
                        }
                        case '\'': {
                            this.sb.append('\'');
                            continue block18;
                        }
                        case '\"': {
                            this.sb.append('\"');
                            continue block18;
                        }
                        case 'u': {
                            this.sb.append(this.readUnicode());
                            continue block18;
                        }
                    }
                    continue block18;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    if (this.ignoreControlChar) continue block18;
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
            }
            this.sb.append(this.c);
        }
    }

    private char readUnicode() throws ParseException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value *= 16;
            this.read();
            if (this.c >= '0' && this.c <= '9') {
                value += this.c - 48;
                continue;
            }
            if (this.c >= 'A' && this.c <= 'F') {
                value += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 'a' && this.c <= 'f') {
                value += this.c - 97 + 10;
                continue;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos, 3, "EOF");
            }
            throw new ParseException(this.pos, 4, Character.valueOf(this.c));
        }
        return (char)value;
    }

    private void skipDigits() {
        while (this.c != '\u001a') {
            if (this.c < '0' || this.c > '9') {
                return;
            }
            this.read();
        }
        return;
    }

    private void skipNQString(boolean[] stop) {
        while (this.c != '\u001a') {
            if (this.c >= '\u0000' && this.c < '~' && stop[this.c]) {
                return;
            }
            this.read();
        }
        return;
    }

    private void skipSpace() {
        while (this.c != '\u001a') {
            if (this.c != ' ' && this.c != '\r' && this.c != '\t' && this.c != '\n') {
                return;
            }
            this.read();
        }
        return;
    }
}

