/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.ovh.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minidev.ovh.api.cdn.website.OvhBackend;
import net.minidev.ovh.api.cdn.website.OvhDomain;
import net.minidev.ovh.api.cdn.website.OvhStatsDataType;
import net.minidev.ovh.api.cdn.website.OvhStatsPeriodEnum;
import net.minidev.ovh.api.cdn.website.OvhStatsTypeEnum;
import net.minidev.ovh.api.cdn.website.OvhStatsValueEnum;
import net.minidev.ovh.api.cdn.website.OvhTask;
import net.minidev.ovh.api.cdn.website.OvhWebsite;
import net.minidev.ovh.api.cdn.website.OvhZone;
import net.minidev.ovh.api.services.OvhService;
import net.minidev.ovh.core.ApiOvhBase;
import net.minidev.ovh.core.ApiOvhCore;

public class ApiOvhCdnwebsite
extends ApiOvhBase {
    private static TypeReference<ArrayList<String>> t1 = new TypeReference<ArrayList<String>>(){};
    private static TypeReference<ArrayList<Long>> t2 = new TypeReference<ArrayList<Long>>(){};
    private static TypeReference<ArrayList<OvhStatsDataType>> t3 = new TypeReference<ArrayList<OvhStatsDataType>>(){};

    public ApiOvhCdnwebsite(ApiOvhCore core) {
        super(core);
    }

    public ArrayList<String> GET() throws IOException {
        String qPath = "/cdn/website";
        StringBuilder sb = this.path(qPath, new Object[0]);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhWebsite serviceName_GET(String serviceName) throws IOException {
        String qPath = "/cdn/website/{serviceName}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhWebsite)this.convertTo(resp, OvhWebsite.class);
    }

    public OvhService serviceName_serviceInfos_GET(String serviceName) throws IOException {
        String qPath = "/cdn/website/{serviceName}/serviceInfos";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhService)this.convertTo(resp, OvhService.class);
    }

    public void serviceName_serviceInfos_PUT(String serviceName, OvhService body) throws IOException {
        String qPath = "/cdn/website/{serviceName}/serviceInfos";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public OvhTask serviceName_zone_backends_ipv4_tasks_taskId_GET(String serviceName, String ipv4, Long taskId) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/backends/{ipv4}/tasks/{taskId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, ipv4, taskId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }

    public ArrayList<Long> serviceName_zone_backends_ipv4_tasks_GET(String serviceName, String ipv4) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/backends/{ipv4}/tasks";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, ipv4});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t2);
    }

    public OvhBackend serviceName_zone_backends_ipv4_GET(String serviceName, String ipv4) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/backends/{ipv4}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, ipv4});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhBackend)this.convertTo(resp, OvhBackend.class);
    }

    public OvhTask serviceName_zone_backends_ipv4_DELETE(String serviceName, String ipv4) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/backends/{ipv4}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, ipv4});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }

    public ArrayList<String> serviceName_zone_backends_GET(String serviceName) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/backends";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhTask serviceName_zone_backends_POST(String serviceName, String ipv4) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/backends";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "ipv4", ipv4);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }

    public ArrayList<Long> serviceName_zone_domains_domain_tasks_GET(String serviceName, String domain) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/domains/{domain}/tasks";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, domain});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t2);
    }

    public OvhTask serviceName_zone_domains_domain_tasks_taskId_GET(String serviceName, String domain, Long taskId) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/domains/{domain}/tasks/{taskId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, domain, taskId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }

    public OvhDomain serviceName_zone_domains_domain_GET(String serviceName, String domain) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/domains/{domain}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, domain});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhDomain)this.convertTo(resp, OvhDomain.class);
    }

    public OvhTask serviceName_zone_domains_domain_DELETE(String serviceName, String domain) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/domains/{domain}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, domain});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }

    public ArrayList<OvhStatsDataType> serviceName_zone_domains_domain_statistics_GET(String serviceName, String domain, OvhStatsPeriodEnum period, OvhStatsTypeEnum type, OvhStatsValueEnum value) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/domains/{domain}/statistics";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, domain});
        this.query(sb, "period", (Object)period);
        this.query(sb, "type", (Object)type);
        this.query(sb, "value", (Object)value);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t3);
    }

    public OvhTask serviceName_zone_domains_domain_flush_POST(String serviceName, String domain) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/domains/{domain}/flush";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, domain});
        String resp = this.exec(qPath, "POST", sb.toString(), null);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }

    public ArrayList<String> serviceName_zone_domains_GET(String serviceName) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/domains";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhDomain serviceName_zone_domains_POST(String serviceName, String domain) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/domains";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "domain", domain);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhDomain)this.convertTo(resp, OvhDomain.class);
    }

    public ArrayList<Long> serviceName_zone_tasks_GET(String serviceName) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/tasks";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t2);
    }

    public OvhTask serviceName_zone_tasks_taskId_GET(String serviceName, Long taskId) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone/tasks/{taskId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, taskId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }

    public OvhZone serviceName_zone_GET(String serviceName) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhZone)this.convertTo(resp, OvhZone.class);
    }

    public OvhZone serviceName_zone_POST(String serviceName, String zone) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "zone", zone);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhZone)this.convertTo(resp, OvhZone.class);
    }

    public OvhTask serviceName_zone_DELETE(String serviceName) throws IOException {
        String qPath = "/cdn/website/{serviceName}/zone";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }
}

