/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.xlsx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class XlsxBuilder {
    public Workbook wb;
    TreeMap<String, Sheet> sheets;
    String currentTab;
    public Sheet sh;
    int rid;
    TreeMap<String, CellStyle> styles = new TreeMap();
    CellStyle style = null;

    public XlsxBuilder() {
        this.wb = new SXSSFWorkbook(100);
        this.sheets = new TreeMap();
    }

    public void setColumnWidth(int ... sizes) {
        int i = 0;
        int[] nArray = sizes;
        int n = sizes.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            if (size == -1) {
                this.sh.autoSizeColumn(i);
            } else {
                this.sh.setColumnWidth(i, size * 256);
            }
            ++i;
            ++n2;
        }
    }

    public void setSheet(String name) {
        this.currentTab = name;
        this.sh = this.wb.getSheet(name);
        if (this.sh == null) {
            this.sh = this.wb.createSheet(name);
            this.rid = 0;
        } else {
            this.rid = this.sh.getLastRowNum() + 1;
        }
    }

    public int getRid() {
        return this.rid;
    }

    public void save(String fileName) throws IOException {
        this.save(new File(fileName));
    }

    public void save(File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        this.wb.write((OutputStream)out);
        out.close();
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public void addLine(Object ... data) {
        Row row = this.sh.createRow(this.rid++);
        int cellId = 0;
        Object[] objectArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object s1 = objectArray[n2];
            Object s = s1 instanceof StyledElm ? ((StyledElm)s1).data : s1;
            Cell cell = row.createCell(cellId++);
            if (s instanceof String) {
                cell.setCellValue(s.toString());
            } else if (s instanceof Number) {
                cell.setCellType(0);
                cell.setCellValue(((Number)s).doubleValue());
            } else if (s instanceof URL) {
                Hyperlink link = null;
                link = this.wb.getCreationHelper().createHyperlink(1);
                link.setAddress(s.toString());
                cell.setHyperlink(link);
                cell.setCellValue(s.toString());
            }
            if (s1 instanceof StyledElm) {
                cell.setCellStyle(((StyledElm)s1).style);
                if (((StyledElm)s1).comment != null) {
                    CreationHelper factory = this.wb.getCreationHelper();
                    ClientAnchor anchor = factory.createClientAnchor();
                    anchor.setCol1(cell.getColumnIndex());
                    anchor.setCol2(cell.getColumnIndex() + 1);
                    anchor.setRow1(row.getRowNum());
                    anchor.setRow2(row.getRowNum() + 3);
                    Drawing drawing = this.sh.createDrawingPatriarch();
                    Comment comment = drawing.createCellComment(anchor);
                    RichTextString str = factory.createRichTextString(((StyledElm)s1).comment);
                    comment.setString(str);
                    comment.setAuthor("info");
                    cell.setCellComment(comment);
                }
            } else if (this.style != null) {
                cell.setCellStyle(this.style);
            }
            ++n2;
        }
    }

    public CellStyle getCellStyle(String color) {
        CellStyle style = this.styles.get(color);
        if (style != null) {
            return style;
        }
        if (color.equalsIgnoreCase("red")) {
            style = this.wb.createCellStyle();
            style.setFillForegroundColor(IndexedColors.RED.getIndex());
            Font font = this.wb.createFont();
            font.setBoldweight((short)700);
            font.setColor(IndexedColors.WHITE.index);
            style.setFont(font);
        } else {
            if (color.equalsIgnoreCase("small6")) {
                style = this.wb.createCellStyle();
                Font font = this.wb.createFont();
                font.setFontHeightInPoints((short)6);
                style.setFont(font);
                this.RegisterStyle(color, style);
                return style;
            }
            if (color.equalsIgnoreCase("small8")) {
                style = this.wb.createCellStyle();
                Font font = this.wb.createFont();
                font.setFontHeightInPoints((short)8);
                style.setFont(font);
                this.RegisterStyle(color, style);
                return style;
            }
            if (color.equalsIgnoreCase("green")) {
                style = this.wb.createCellStyle();
                style.setFillForegroundColor(IndexedColors.GREEN.getIndex());
            } else if (color.equalsIgnoreCase("lightBlue")) {
                style = this.wb.createCellStyle();
                style.setFillForegroundColor(IndexedColors.BLUE.getIndex());
                Font font = this.wb.createFont();
                font.setBoldweight((short)700);
                font.setColor(IndexedColors.WHITE.index);
                style.setFont(font);
            } else if (color.equalsIgnoreCase("lightGreen")) {
                style = this.wb.createCellStyle();
                style.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
            } else if (color.equalsIgnoreCase("orange")) {
                style = this.wb.createCellStyle();
                style.setFillForegroundColor(IndexedColors.ORANGE.getIndex());
            } else if (color.equalsIgnoreCase("yellow")) {
                style = this.wb.createCellStyle();
                style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
            } else if (color.equalsIgnoreCase("bold")) {
                style = this.wb.createCellStyle();
                style.setBorderBottom((short)2);
                style.setBorderLeft((short)2);
                style.setBorderRight((short)2);
                style.setBorderTop((short)2);
                Font font = this.wb.createFont();
                font.setBoldweight((short)700);
                style.setFont(font);
                style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            }
        }
        if (style != null) {
            style.setFillPattern((short)1);
            this.RegisterStyle(color, style);
        }
        return style;
    }

    public void RegisterStyle(String color, CellStyle style) {
        this.styles.put(color, style);
    }

    public void setColor(String color) {
        if (color == null) {
            this.style = null;
            return;
        }
        this.style = this.getCellStyle(color);
    }

    public class StyledElm {
        public CellStyle style;
        public Object data;
        public String comment;

        public StyledElm(Object data, CellStyle style) {
            this(data, style, null);
        }

        public StyledElm(Object data, CellStyle style, String comment) {
            this.data = data;
            this.style = style;
            this.comment = comment;
        }

        public StyledElm(Object data, String style) {
            this(data, style, null);
        }

        public StyledElm(Object data, String style, String comment) {
            this(data, xlsxBuilder.getCellStyle(style), comment);
        }
    }
}

