/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.xlsx;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxReader {
    public static ArrayList<ArrayList<Object>> readXlsx(File filename, String sheetName) throws IOException {
        return XlsxReader.readXlsx(filename.getAbsolutePath(), sheetName);
    }

    public static ArrayList<ArrayList<Object>> readXlsx(String filename, String sheetName) throws IOException {
        FileInputStream fis = null;
        fis = new FileInputStream(filename);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);
        XSSFSheet sheet = workbook.getSheet(sheetName);
        ArrayList<ArrayList<Object>> out = XlsxReader.readXlsx_(workbook, (Sheet)sheet);
        if (fis != null) {
            fis.close();
        }
        return out;
    }

    public static LinkedHashMap<String, ArrayList<ArrayList<Object>>> readXlsx(String filename) throws IOException {
        LinkedHashMap<String, ArrayList<ArrayList<Object>>> ret = new LinkedHashMap<String, ArrayList<ArrayList<Object>>>();
        FileInputStream fis = null;
        fis = new FileInputStream(filename);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);
        for (Sheet sheet : workbook) {
            String sheetName = sheet.getSheetName();
            ArrayList<ArrayList<Object>> out = XlsxReader.readXlsx_(workbook, sheet);
            ret.put(sheetName, out);
        }
        if (fis != null) {
            fis.close();
        }
        return ret;
    }

    public static ArrayList<ArrayList<Object>> readXlsx(String filename, Integer sheetNum) throws IOException {
        FileInputStream fis = null;
        fis = new FileInputStream(filename);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);
        XSSFSheet sheet = workbook.getSheetAt(sheetNum.intValue());
        ArrayList<ArrayList<Object>> out = XlsxReader.readXlsx_(workbook, (Sheet)sheet);
        if (fis != null) {
            fis.close();
        }
        return out;
    }

    private static ArrayList<ArrayList<Object>> readXlsx_(XSSFWorkbook workbook, Sheet sheet) throws IOException {
        ArrayList<ArrayList<Object>> result = new ArrayList<ArrayList<Object>>();
        Iterator rows = sheet.rowIterator();
        XSSFFormulaEvaluator eval = workbook.getCreationHelper().createFormulaEvaluator();
        while (rows.hasNext()) {
            ArrayList<Object> next = new ArrayList<Object>();
            XSSFRow row = (XSSFRow)rows.next();
            Iterator cells = row.cellIterator();
            block14: while (cells.hasNext()) {
                XSSFCell cell = (XSSFCell)cells.next();
                if (cell == null) {
                    next.add(null);
                    continue;
                }
                int idx = cell.getColumnIndex();
                while (next.size() < idx) {
                    next.add(null);
                }
                int type = cell.getCellType();
                switch (type) {
                    case 3: {
                        next.add(null);
                        break;
                    }
                    case 4: {
                        next.add(cell.getBooleanCellValue());
                        break;
                    }
                    case 5: {
                        next.add(null);
                        break;
                    }
                    case 2: {
                        try {
                            CellValue cellValue = eval.evaluate((Cell)cell);
                            switch (cellValue.getCellType()) {
                                case 0: {
                                    double v = cellValue.getNumberValue();
                                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                        next.add(DateUtil.getJavaDate((double)v, (boolean)true));
                                        break;
                                    }
                                    next.add(v);
                                }
                            }
                        }
                        catch (Exception e) {
                            System.err.println("ERROR evaluating !" + sheet.getSheetName() + " ROW:" + row.getRowNum() + " col:" + cell.getColumnIndex() + " formula:" + cell.getCellFormula());
                            next.add(cell.getCellFormula());
                        }
                        continue block14;
                    }
                    case 0: {
                        if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                            next.add(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                            break;
                        }
                        String raw = cell.getRawValue();
                        next.add(raw);
                        break;
                    }
                    case 1: {
                        next.add(cell.getStringCellValue());
                        break;
                    }
                    default: {
                        next.add(null);
                    }
                }
            }
            result.add(next);
        }
        return result;
    }

    public static String getString(List<Object> list, int pos) {
        if (list.size() <= pos) {
            return null;
        }
        Object obj = list.get(pos);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }
}

