/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Base64;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private final byte[] decodabet;
    private final byte[] buffer3;
    private final int options;
    private final byte[] buffer4;
    private int position;
    private int numSigBytes;

    public Base64InputStream(InputStream in, int options) {
        super(in);
        if (in == null) {
            throw new IllegalArgumentException("null input stream");
        }
        this.options = options;
        this.buffer3 = new byte[3];
        this.buffer4 = new byte[4];
        this.position = -1;
        this.numSigBytes = 0;
        this.decodabet = Base64.getDecodabet(options);
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            throw new IOException("Reading from a closed Base64InputStream");
        }
        if (this.position < 0) {
            int i;
            for (i = 0; i < 4; ++i) {
                int b;
                while ((b = this.in.read()) >= 0 && this.decodabet[b & 0x7F] == -5) {
                }
                if (b < 0) break;
                this.buffer4[i] = (byte)b;
            }
            this.position = 0;
            if (i == 0) {
                this.numSigBytes = 0;
                return -1;
            }
            try {
                this.numSigBytes = Base64.decode4to3(this.buffer4, i, this.buffer3, 0, this.decodabet);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (this.position >= this.numSigBytes) {
            return -1;
        }
        int b = this.buffer3[this.position++] & 0xFF;
        if (this.position >= 3) {
            this.position = -1;
            this.numSigBytes = 0;
        }
        return b;
    }

    @Override
    public int read(byte[] dest, int off, int len) throws IOException {
        int b;
        int i;
        if (len == 0) {
            return 0;
        }
        for (i = 0; i < len && (b = this.read()) >= 0; ++i) {
            dest[off + i] = (byte)b;
        }
        return i > 0 ? i : -1;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        return (this.position >= 0 ? this.numSigBytes - this.position : 0) + (this.in.available() > 0 ? 1 : 0);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip/reset not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

