/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.BaseBundle;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.util.Pair;
import java.util.Collections;
import java.util.Map;

public final class PersistableBundle
extends BaseBundle
implements Parcelable,
Cloneable {
    public static final Parcelable.Creator<PersistableBundle> CREATOR = new Parcelable.Creator<PersistableBundle>(){

        @Override
        public PersistableBundle createFromParcel(Parcel source) {
            int size = source.readInt();
            PersistableBundle bundle = new PersistableBundle(size);
            for (int i = 0; i < size; ++i) {
                BaseBundle.Type type;
                String key = source.readString();
                if (bundle.readFromParcel(source, key, type = BaseBundle.Type.valueOf(source.readInt()))) continue;
                if (BaseBundle.Type.PERSISTABLE_BUNDLE.equals((Object)type)) {
                    bundle.putPersistableBundle(key, this.createFromParcel(source));
                    continue;
                }
                throw new ParcelFormatException("Unknown type for persistable bundle deserialization " + (Object)((Object)type));
            }
            return bundle;
        }

        public PersistableBundle[] newArray(int size) {
            return new PersistableBundle[size];
        }
    };
    public static final PersistableBundle EMPTY = new PersistableBundle(Collections.EMPTY_MAP);
    private boolean isWriting = false;

    public PersistableBundle(int capacity) {
        super(capacity);
    }

    public PersistableBundle() {
        this(0);
    }

    public PersistableBundle(PersistableBundle bundle) {
        this(bundle.size());
        this.putAll(bundle);
    }

    public Object clone() {
        return new PersistableBundle(this);
    }

    public PersistableBundle getPersistableBundle(String key) {
        Pair entry = (Pair)this.map.get(key);
        if (entry != null && ((BaseBundle.Type)((Object)entry.first)).equals((Object)BaseBundle.Type.PERSISTABLE_BUNDLE)) {
            return (PersistableBundle)entry.second;
        }
        return null;
    }

    public void putPersistableBundle(String key, PersistableBundle bundle) {
        this.put(key, BaseBundle.Type.PERSISTABLE_BUNDLE, bundle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Map map = this.map;
        synchronized (map) {
            if (this.isWriting) {
                throw new BadParcelableException("Trying to write with circular references.");
            }
            try {
                this.isWriting = true;
                dest.writeInt(this.size());
                for (Map.Entry entry : this.map.entrySet()) {
                    if (this.writeToParcel(dest, (String)entry.getKey(), (BaseBundle.Type)((Object)((Pair)entry.getValue()).first), ((Pair)entry.getValue()).second)) continue;
                    if (((BaseBundle.Type)((Object)((Pair)entry.getValue()).first)).equals((Object)BaseBundle.Type.PERSISTABLE_BUNDLE)) {
                        PersistableBundle inner = (PersistableBundle)((Pair)entry.getValue()).second;
                        inner.writeToParcel(dest, flags);
                        continue;
                    }
                    throw new BadParcelableException("Unknown type for persistable bundle serialization " + ((Pair)entry.getValue()).first);
                }
            }
            finally {
                this.isWriting = false;
            }
        }
    }

    private PersistableBundle(Map<String, Pair<BaseBundle.Type, Object>> map) {
        super(map);
    }
}

