/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api;

import com.artemis.ArtemisPlugin;
import com.artemis.Aspect;
import com.artemis.AspectSubscriptionManager;
import com.artemis.BaseSystem;
import com.artemis.Component;
import com.artemis.EntityEdit;
import com.artemis.EntitySubscription;
import com.artemis.World;
import com.artemis.WorldConfigurationBuilder;
import com.artemis.injection.FieldResolver;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.mostlyoriginal.api.Singleton;
import net.mostlyoriginal.api.SingletonException;

public class SingletonPlugin
implements ArtemisPlugin {
    private final boolean strict;

    public SingletonPlugin() {
        this(true);
    }

    public SingletonPlugin(boolean strict) {
        this.strict = strict;
    }

    public void setup(WorldConfigurationBuilder b) {
        SingletonFieldResolver singletonResolver = new SingletonFieldResolver();
        b.register(new FieldResolver[]{singletonResolver});
        if (this.strict) {
            b.with(new BaseSystem[]{new SingletonValidationSystem(singletonResolver)});
        }
    }

    public static class SingletonValidationSystem
    extends BaseSystem
    implements EntitySubscription.SubscriptionListener {
        private final SingletonFieldResolver singletonResolver;
        private final Set<Class<? extends Component>> singletonComponents;
        private AspectSubscriptionManager asm;

        public SingletonValidationSystem(SingletonFieldResolver singletonResolver) {
            this.singletonResolver = singletonResolver;
            this.singletonComponents = new HashSet<Class<? extends Component>>();
        }

        protected void initialize() {
            this.setEnabled(false);
            if (this.singletonResolver.cachedSingletons.size() > 0) {
                this.singletonComponents.addAll(this.singletonResolver.cachedSingletons.keySet());
                this.asm.get(Aspect.one(this.singletonComponents)).addSubscriptionListener((EntitySubscription.SubscriptionListener)this);
            }
        }

        protected void processSystem() {
        }

        public void inserted(IntBag entities) {
            throw new SingletonException(this.singletonComponents);
        }

        public void removed(IntBag entities) {
        }
    }

    public static class SingletonFieldResolver
    implements FieldResolver {
        private HashMap<Class<? extends Component>, Component> cachedSingletons;
        private EntityEdit singletonContainerEntity;

        public void initialize(World world) {
            this.cachedSingletons = new HashMap();
            this.singletonContainerEntity = world.createEntity().edit();
        }

        public Object resolve(Object target, Class<?> fieldType, Field field) {
            if (ClassReflection.isAnnotationPresent(fieldType, Singleton.class) && ClassReflection.isAssignableFrom(Component.class, fieldType)) {
                return this.getCreateSingletonComponent(fieldType);
            }
            return null;
        }

        private Component getCreateSingletonComponent(Class<Component> component) {
            if (!this.cachedSingletons.containsKey(component)) {
                this.cachedSingletons.put(component, this.singletonContainerEntity.create(component));
            }
            return this.cachedSingletons.get(component);
        }
    }
}

