/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    public static final Pattern SEMVER_DETECT = Pattern.compile("\\bv?(?:0|[1-9][0-9]*)\\.(?:0|[1-9][0-9]*)\\.(?:0|[1-9][0-9]*)(?:-[\\da-z\\-]+(?:\\.[\\da-z\\-]+)*)?(?:\\+[\\da-z\\-]+(?:\\.[\\da-z\\-]+)*)?\\b", 2);
    public static final Pattern SEMVER_FORMAT = Pattern.compile("v?(0|[1-9][0-9]*)\\.(0|[1-9][0-9]*)(?:\\.(0|[1-9][0-9]*))?(?:-([\\da-z\\-]+(?:\\.[\\da-z\\-]+)*))?(?:\\+([\\da-z\\-]+(?:\\.[\\da-z\\-]+)*))?", 2);
    public static final String SNAPSHOT = "SNAPSHOT";
    private int major;
    private int minor;
    private int patch;
    private String preRelease;
    private String build;
    private boolean snapshot;

    public Version(int major) {
        this(major, 0);
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, "", "");
    }

    public Version(int major, int minor, int patch, boolean snapshot) {
        this(major, minor, patch, snapshot ? SNAPSHOT : "", "");
    }

    public Version(int major, int minor, int patch, String preRelease, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease != null ? preRelease : "";
        this.build = build != null ? build : "";
        this.checkSnapshot();
    }

    public Version(String text) throws IllegalArgumentException {
        Matcher matcher = SEMVER_FORMAT.matcher(text.trim());
        int i = matcher.groupCount();
        if (!matcher.matches() || 0 > i) {
            throw new IllegalArgumentException("Invalid version string");
        }
        String majorStr = matcher.group(1);
        String minorStr = matcher.group(2);
        String patchStr = matcher.group(3);
        this.major = Integer.parseInt(majorStr);
        this.minor = Integer.parseInt(minorStr);
        this.patch = patchStr == null ? 0 : Integer.parseInt(patchStr);
        String preReleaseStr = matcher.group(4);
        this.preRelease = preReleaseStr != null ? preReleaseStr : "";
        String buildStr = matcher.group(5);
        this.build = buildStr != null ? buildStr : "";
        this.checkSnapshot();
    }

    private void checkSnapshot() {
        this.snapshot = this.preRelease.equalsIgnoreCase(SNAPSHOT);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public String getBuild() {
        return this.build;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (!this.preRelease.isEmpty()) {
            builder.append('-');
            if (this.isSnapshot()) {
                builder.append(SNAPSHOT);
            } else {
                builder.append(this.preRelease);
            }
        }
        if (!this.build.isEmpty()) {
            builder.append('+').append(this.build);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch && this.preRelease.equalsIgnoreCase(version.preRelease) && this.build.equalsIgnoreCase(version.build);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + this.preRelease.toLowerCase().hashCode();
        result = 31 * result + this.build.toLowerCase().hashCode();
        return result;
    }

    @Override
    public int compareTo(Version other) {
        int result = this.major - other.major;
        if (result == 0) {
            result = this.minor - other.minor;
        }
        if (result == 0) {
            result = this.patch - other.patch;
        }
        if (result == 0) {
            result = this.preRelease.compareTo(other.preRelease);
        }
        return result;
    }

    public static Version[] parseMulti(String ... versions) {
        if (versions == null) {
            return new Version[0];
        }
        LinkedList<Version> results = new LinkedList<Version>();
        for (String version : versions) {
            Matcher matcher = SEMVER_DETECT.matcher(version.toLowerCase());
            while (matcher.find()) {
                try {
                    String match = matcher.group();
                    results.add(new Version(match));
                }
                catch (IllegalArgumentException ignore) {}
            }
        }
        return results.toArray(new Version[results.size()]);
    }

    public static Version parse(String version) throws IllegalArgumentException {
        Version[] versions = Version.parseMulti(version);
        if (versions.length < 1) {
            throw new IllegalArgumentException("Cannot set empty / illegal version: " + version);
        }
        if (versions.length > 1) {
            throw new IllegalArgumentException("Invalid version tag; more than one version found: " + version);
        }
        return versions[0];
    }
}

