/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public final class Annotations {
    private static final Object NOTHING = new Object();

    private Annotations() {
    }

    public static Object call(Object object, Class<? extends Annotation> annotation, int required, Class<?>[] argTypes, Object ... args) throws InvocationTargetException, IllegalAccessException {
        List<Method> declaredMethods = Arrays.asList(object.getClass().getDeclaredMethods());
        for (Method method : declaredMethods) {
            Object returnValue = Annotations.callMethod(object, annotation, required, argTypes, method, args);
            if (NOTHING.equals(returnValue)) continue;
            return returnValue;
        }
        for (Method method : object.getClass().getMethods()) {
            Object returnValue;
            if (declaredMethods.contains(method) || NOTHING.equals(returnValue = Annotations.callMethod(object, annotation, required, argTypes, method, args))) continue;
            return returnValue;
        }
        return null;
    }

    private static Object callMethod(Object object, Class<? extends Annotation> annotation, int required, Class<?>[] argTypes, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        if (method.getAnnotation(annotation) == null) {
            return NOTHING;
        }
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        if (methodParameterTypes.length < required) {
            return NOTHING;
        }
        int counter = argTypes.length;
        do {
            if (!Annotations.isApplicable(Arrays.copyOf(methodParameterTypes, counter), argTypes)) continue;
            method.setAccessible(true);
            if (counter > 0) {
                return method.invoke(object, Arrays.copyOf(args, counter));
            }
            return method.invoke(object, new Object[0]);
        } while (counter-- >= required);
        return null;
    }

    private static boolean isApplicable(Class<?>[] method, Class<?>[] parameters) {
        for (int i = method.length - 1; i >= 0; --i) {
            Class<?> aClass = method[i];
            if (aClass != null && aClass.isAssignableFrom(parameters[i])) continue;
            return false;
        }
        return true;
    }
}

