/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular.impl;

import com.google.common.base.Optional;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.mountainblade.modular.Filter;
import net.mountainblade.modular.Module;
import net.mountainblade.modular.ModuleInformation;
import net.mountainblade.modular.ModuleManager;
import net.mountainblade.modular.ModuleState;
import net.mountainblade.modular.annotations.Shutdown;
import net.mountainblade.modular.impl.Annotations;
import net.mountainblade.modular.impl.DefaultModuleManager;
import net.mountainblade.modular.impl.Destroyable;
import net.mountainblade.modular.impl.Injector;
import net.mountainblade.modular.impl.MavenModuleInformation;
import net.mountainblade.modular.impl.ModuleInformationImpl;
import net.mountainblade.modular.impl.ModuleLoader;
import net.mountainblade.modular.impl.ModuleRegistry;
import net.mountainblade.modular.impl.TopologicalSortedList;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;

public class BaseModuleManager
implements ModuleManager {
    private static final Logger LOG = Logger.getLogger(DefaultModuleManager.class.getName());
    private static final ClassWorld CLASS_WORLD = new ClassWorld();
    private static final String JAVA_HOME = new File(System.getProperty("java.home")).getParent();
    private static final List<URI> LOCAL_CLASSPATH = new LinkedList<URI>();
    private static final Map<URI, Collection<String>> JAR_CACHE = new THashMap();
    private static final Collection<String> BLACKLIST = new THashSet();
    private static final Collection<URI> URI_BLACKLIST = new THashSet();
    private static boolean thoroughSearchEnabled;
    static boolean includedFullClassPath;
    private final Collection<Destroyable> destroyables = new LinkedList<Destroyable>();
    private final Collection<URI> classpath = BaseModuleManager.createClassPathSet(LOCAL_CLASSPATH);
    private final ModuleRegistry registry;
    private final Injector injector;
    private final ModuleLoader loader;

    public BaseModuleManager(ModuleRegistry registry, ClassRealm parentRealm, ClassLoader classLoader) {
        this(registry, BaseModuleManager.newRealm(parentRealm, classLoader));
    }

    public BaseModuleManager(ModuleRegistry registry, ClassRealm realm) {
        this.registry = registry;
        this.injector = new Injector(registry);
        this.loader = new ModuleLoader(realm, registry, this.injector);
        this.destroyables.add(registry);
        this.destroyables.add(this.injector);
        this.destroyables.add(this.loader);
        this.getRegistry().addGhostModule(ModuleManager.class, this, new MavenModuleInformation());
    }

    @Override
    public final ModuleRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public final Injector getInjector() {
        return this.injector;
    }

    @Override
    public final ModuleLoader getLoader() {
        return this.loader;
    }

    @Override
    public <T extends Module> T provideSimple(T module) {
        return this.provide(module, false);
    }

    @Override
    public <T extends Module> T provide(T module) {
        return this.provide(module, true);
    }

    private <T extends Module> T provide(T module, boolean inject) {
        if (module == null) {
            LOG.warning("Provided with null instance, will not add to registry");
            return null;
        }
        ModuleLoader.ClassEntry entry = this.loader.getClassEntry(module.getClass());
        if (entry == null) {
            LOG.warning("Provided with invalid module, will not at to registry");
            return null;
        }
        ModuleInformationImpl information = new ModuleInformationImpl(entry.getAnnotation());
        ModuleRegistry.Entry moduleEntry = this.registry.createEntry(entry.getModule(), information);
        if (inject) {
            this.loader.injectAndInitialize(this, module, information);
        }
        this.loader.registerEntry(entry, module, information, moduleEntry);
        return module;
    }

    @Override
    public <M extends Module> M loadModule(Class<M> moduleClass, Filter ... filters) {
        return (M)this.loader.loadModule(this, this.loader.getClassEntry(moduleClass));
    }

    @Override
    public Collection<Module> loadModules(String resource, Filter ... filters) {
        try {
            Class<?> theClass = Class.forName(resource, true, (ClassLoader)this.loader.getRealm());
            if (theClass != null && this.loader.isValidModuleClass(theClass)) {
                return Collections.singleton(this.loadModule(theClass, filters));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.loadModules(this.classpath, resource.replace('.', File.separatorChar), filters);
    }

    @Override
    public Collection<Module> loadModules(File file, Filter ... filters) {
        return this.loadModules(file.toURI(), filters);
    }

    @Override
    public Collection<Module> loadModules(URI uri, Filter ... filters) {
        return this.loadModules(uri, "", filters);
    }

    @Override
    public Collection<Module> loadModules(URI uri, String packageName, Filter ... filters) {
        return this.loadModules(Collections.singletonList(uri), packageName, filters);
    }

    @Override
    public Collection<Module> loadModules(Collection<URI> uris, String root, Filter ... filters) {
        LinkedList<URI> copy = new LinkedList<URI>(uris);
        THashMap map = new THashMap();
        LinkedList<String> list = new LinkedList<String>();
        Collection<ModuleLoader.ClassEntry> entries = this.loader.filter(this, this.getClasses(copy, root, (Map<URI, Collection<String>>)map, list), list);
        for (Filter filter : filters) {
            Iterator<ModuleLoader.ClassEntry> iterator = entries.iterator();
            while (iterator.hasNext()) {
                ModuleLoader.ClassEntry classEntry = iterator.next();
                if (filter.retain(classEntry)) continue;
                iterator.remove();
            }
        }
        THashMap nodes = new THashMap();
        TopologicalSortedList<ModuleLoader.ClassEntry> sortedCandidates = new TopologicalSortedList<ModuleLoader.ClassEntry>();
        for (ModuleLoader.ClassEntry classEntry : entries) {
            TopologicalSortedList.Node<ModuleLoader.ClassEntry> node = (TopologicalSortedList.Node<ModuleLoader.ClassEntry>)((Object)nodes.get(classEntry));
            if (node == null) {
                node = sortedCandidates.addNode(classEntry);
                nodes.put(classEntry, node);
            }
            for (Injector.Entry entry : classEntry.getDependencies()) {
                this.addDependency(classEntry, node, entry.getDependency(), (Map<ModuleLoader.ClassEntry, TopologicalSortedList.Node<ModuleLoader.ClassEntry>>)nodes, sortedCandidates);
            }
            for (Class clazz : classEntry.getRequirements()) {
                this.addDependency(classEntry, node, clazz, (Map<ModuleLoader.ClassEntry, TopologicalSortedList.Node<ModuleLoader.ClassEntry>>)nodes, sortedCandidates);
            }
        }
        LinkedList<Module> modules = new LinkedList<Module>();
        try {
            sortedCandidates.sort();
        }
        catch (TopologicalSortedList.CycleException e) {
            LOG.log(Level.WARNING, "Error sorting module load order, found dependency cycle", e);
            return modules;
        }
        Iterator iterator = sortedCandidates.iterator();
        while (iterator.hasNext()) {
            TopologicalSortedList.Node candidate = (TopologicalSortedList.Node)((Object)iterator.next());
            Module module = this.loader.loadModule(this, (ModuleLoader.ClassEntry)candidate.getValue());
            if (module == null) {
                LOG.warning("Could not load modules properly, cancelling loading procedure");
                break;
            }
            modules.add(module);
        }
        return modules;
    }

    private void addDependency(ModuleLoader.ClassEntry classEntry, TopologicalSortedList.Node<ModuleLoader.ClassEntry> node, Class<? extends Module> dependency, Map<ModuleLoader.ClassEntry, TopologicalSortedList.Node<ModuleLoader.ClassEntry>> nodes, TopologicalSortedList<ModuleLoader.ClassEntry> sortedCandidates) {
        if (dependency == null || dependency.equals(classEntry.getImplementation())) {
            return;
        }
        ModuleLoader.ClassEntry depClassEntry = this.loader.getClassEntry(dependency);
        if (depClassEntry == null) {
            LOG.warning("Could not get class entry for dependency: " + dependency);
            return;
        }
        TopologicalSortedList.Node<ModuleLoader.ClassEntry> depNode = nodes.get(depClassEntry);
        if (depNode == null) {
            depNode = sortedCandidates.addNode(depClassEntry);
            nodes.put(depClassEntry, depNode);
        }
        depNode.isRequiredBefore((ModuleLoader.ClassEntry)((Object)node));
    }

    private boolean addUriToRealm(URI uri) {
        try {
            this.getLoader().getRealm().addURL(uri.toURL());
            this.classpath.add(uri);
            return true;
        }
        catch (MalformedURLException e) {
            LOG.log(Level.SEVERE, "Could not load modules from malformed URL: " + uri, e);
            return false;
        }
    }

    private Map<URI, Collection<String>> getClasses(Collection<URI> uris, String packageName, Map<URI, Collection<String>> classNames, Collection<String> list) {
        for (URI uri : uris) {
            if (URI_BLACKLIST.contains(uri)) continue;
            if (!uri.getScheme().equalsIgnoreCase("jar") && !uri.getSchemeSpecificPart().endsWith(".jar")) {
                File parent = new File(uri);
                this.walkDirectory(parent, parent, packageName, classNames, list);
                continue;
            }
            this.addUriToRealm(uri);
            Collection<String> cache = JAR_CACHE.get(uri);
            if (cache != null) {
                if (packageName.isEmpty()) {
                    classNames.put(uri, cache);
                    continue;
                }
                LinkedList<String> names = new LinkedList<String>();
                for (String name : cache) {
                    if (!name.startsWith(packageName)) continue;
                    names.add(name);
                    list.add(name);
                }
                classNames.put(uri, names);
                continue;
            }
            LinkedList<String> classes = new LinkedList<String>();
            String scheme = uri.getSchemeSpecificPart();
            int divider = scheme.indexOf("!/");
            File file = new File(divider < 0 ? scheme : scheme.substring(0, divider).replace("file:", ""));
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(file));){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    String properName;
                    String name = entry.getName();
                    if (!entry.isDirectory() && name.endsWith(".class") && !(properName = this.getProperClassName(name)).endsWith("package-info")) {
                        classes.add(properName);
                        if (properName.startsWith(packageName) || name.startsWith(packageName)) {
                            list.add(properName);
                        }
                    }
                    entry = zip.getNextEntry();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not fetch JAR file contents: " + uri + " (using " + file + ')', e);
            }
            classNames.put(uri, classes);
            JAR_CACHE.put(uri, classes);
        }
        return classNames;
    }

    private String getProperClassName(String name) {
        return name.substring(0, name.length() - ".class".length()).replace("\\", "/").replace("/", ".");
    }

    private void walkDirectory(File root, File parent, String packageName, Map<URI, Collection<String>> names, Collection<String> list) {
        File[] listFiles;
        File[] fileArray = listFiles = parent.isDirectory() ? parent.listFiles() : null;
        if (listFiles == null) {
            return;
        }
        for (File file : listFiles) {
            String className;
            String path;
            String substring;
            String name = file.getName();
            if (BaseModuleManager.isBlacklisted(name)) continue;
            if (file.isDirectory()) {
                this.walkDirectory(this.classpath.contains(parent.toURI()) ? parent.getAbsoluteFile() : root, file, packageName, names, list);
                continue;
            }
            URI uri = file.toURI();
            if (name.endsWith(".jar")) {
                this.getClasses(Collections.singleton(uri), packageName, names, list);
                continue;
            }
            if (root == null) {
                root = parent;
            }
            if (!(substring = (path = file.getAbsolutePath()).substring(root.getAbsolutePath().length() + 1)).startsWith(packageName) || !name.endsWith(".class")) continue;
            URI rootUri = root.toURI();
            Collection<String> classNames = names.get(rootUri);
            if (classNames == null) {
                classNames = new LinkedList<String>();
                names.put(rootUri, classNames);
            }
            if ((className = this.getProperClassName(substring)).equalsIgnoreCase("package-info")) continue;
            classNames.add(className);
            list.add(className);
            this.addUriToRealm(rootUri);
        }
    }

    void blacklist(URI uri) {
        URI_BLACKLIST.add(uri);
    }

    @Override
    public <M extends Module> Optional<M> getModule(Class<M> module) {
        return Optional.fromNullable(this.registry.getModule(module));
    }

    @Override
    public Optional<ModuleInformation> getInformation(Class<? extends Module> module) {
        return Optional.fromNullable((Object)this.registry.getInformation(module));
    }

    @Override
    public void shutdown() {
        this.shutdown(this.getRegistry().getModules().iterator());
    }

    protected void shutdown(Iterator<Module> iterator) {
        while (iterator.hasNext()) {
            Module module = iterator.next();
            ModuleRegistry.Entry entry = this.registry.getEntry(this.loader.getClassEntry(module.getClass()).getModule());
            if (entry == null) {
                LOG.warning("Unable to set state to shut down: Could not find entry for module: " + module);
                continue;
            }
            ModuleInformation information = entry.getInformation();
            if (ModuleState.SHUTDOWN.equals((Object)information.getState())) continue;
            try {
                LOG.fine("Shutting down " + module.getClass().getName());
                Annotations.call(module, Shutdown.class, 0, new Class[]{ModuleManager.class}, this);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.log(Level.WARNING, "Could not invoke shutdown method on module: " + module, e);
            }
            if (!(information instanceof ModuleInformationImpl)) continue;
            ((ModuleInformationImpl)information).setState(ModuleState.SHUTDOWN);
        }
        for (Destroyable destroyable : this.destroyables) {
            destroyable.destroy();
        }
    }

    public static ClassRealm newRealm(ClassRealm parent, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = BaseModuleManager.class.getClassLoader();
        }
        try {
            String name = UUID.randomUUID().toString();
            return parent != null ? parent.createChildRealm(name) : CLASS_WORLD.newRealm(name, classLoader);
        }
        catch (DuplicateRealmException e) {
            throw new RuntimeException("Created duplicate realm even though we're using random UUIDs!", e);
        }
    }

    public static void blacklist(String name) {
        BLACKLIST.add(name.toLowerCase());
    }

    public static void include(URI ... uris) {
        Collections.addAll(LOCAL_CLASSPATH, uris);
    }

    public static void includeFullClassPath() {
        String[] paths = System.getProperty("java.class.path", "").split(File.pathSeparator);
        URI[] uris = new URI[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            uris[i] = new File(paths[i]).toURI();
        }
        BaseModuleManager.include(uris);
        includedFullClassPath = true;
    }

    public static void enableThoroughSearch(boolean toggle) {
        thoroughSearchEnabled = toggle;
        LOCAL_CLASSPATH.clear();
        Class<BaseModuleManager> baseClass = BaseModuleManager.class;
        ClassLoader classLoader = baseClass.getClassLoader();
        BaseModuleManager.addToLocalClassPath(classLoader.getResource("."), BaseModuleManager.findClassLoaderRootURL(baseClass));
        if (toggle && classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                String path = url.getPath();
                if (path.startsWith(JAVA_HOME) || BaseModuleManager.isBlacklisted(path)) continue;
                BaseModuleManager.addToLocalClassPath(url);
            }
        }
    }

    public static boolean thoroughSearchEnabled() {
        return thoroughSearchEnabled;
    }

    public static void addToLocalClassPath(URL ... urls) {
        for (URL path : urls) {
            if (path == null) continue;
            try {
                LOCAL_CLASSPATH.add(path.toURI());
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
        }
    }

    public static URL findClassLoaderRootURL(Class aClass) {
        String prefix = aClass.getCanonicalName().replace('.', '/') + ".class";
        URL resource = aClass.getClassLoader().getResource(prefix);
        try {
            if (resource != null) {
                return new URL(resource.toString().replace(prefix, ""));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private static Collection<URI> createClassPathSet(List<URI> uris) {
        THashSet classPath = new THashSet(uris);
        TObjectHashIterator iterator = classPath.iterator();
        while (iterator.hasNext()) {
            URI next = (URI)iterator.next();
            if (next == null) continue;
            String entry = next.toString();
            if (entry.contains(JAVA_HOME)) {
                iterator.remove();
                continue;
            }
            if (!BaseModuleManager.isBlacklisted(entry)) continue;
            iterator.remove();
        }
        return classPath;
    }

    private static boolean isBlacklisted(String name) {
        name = name.toLowerCase();
        for (String blacklisted : BLACKLIST) {
            if (!name.contains(blacklisted)) continue;
            return true;
        }
        return false;
    }

    static {
        Collections.addAll(BLACKLIST, ".git", ".idea");
        String additionalBlacklist = System.getProperty("modular.blacklist");
        if (additionalBlacklist != null) {
            Collections.addAll(BLACKLIST, additionalBlacklist.split(File.pathSeparator));
        }
        BaseModuleManager.enableThoroughSearch(System.getProperty("modular.thoroughSearch") != null);
        if (System.getProperty("modular.includeFullClassPath") != null) {
            BaseModuleManager.includeFullClassPath();
        }
    }
}

