/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular.impl;

import com.google.common.base.Optional;
import net.mountainblade.modular.Module;
import net.mountainblade.modular.ModuleInformation;
import net.mountainblade.modular.impl.BaseModuleManager;
import net.mountainblade.modular.impl.HierarchicModuleRegistry;

public class HierarchicModuleManager
extends BaseModuleManager {
    private final BaseModuleManager parent;

    public HierarchicModuleManager(BaseModuleManager parent) {
        this(parent, null);
    }

    public HierarchicModuleManager(BaseModuleManager parent, ClassLoader loader) {
        super(new HierarchicModuleRegistry(parent.getRegistry()), HierarchicModuleManager.newRealm(parent.getLoader().getRealm(), loader));
        this.parent = parent;
    }

    @Override
    public <M extends Module> Optional<M> getModule(Class<M> module) {
        Optional<M> parentModule = this.parent.getModule(module);
        return parentModule.isPresent() ? parentModule : super.getModule(module);
    }

    @Override
    public Optional<ModuleInformation> getInformation(Class<? extends Module> module) {
        Optional<ModuleInformation> parentInfo = this.parent.getInformation(module);
        return parentInfo.isPresent() ? parentInfo : super.getInformation(module);
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean withParent) {
        HierarchicModuleRegistry registry = (HierarchicModuleRegistry)this.getRegistry();
        this.shutdown(withParent ? registry.getModules().iterator() : registry.getChildModules());
    }
}

