/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular.impl;

import com.google.common.collect.Sets;
import gnu.trove.map.hash.THashMap;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.mountainblade.modular.Module;
import net.mountainblade.modular.impl.ModuleRegistry;

class HierarchicModuleRegistry
extends ModuleRegistry {
    private final CombinedCollection<Module> modules;

    HierarchicModuleRegistry(ModuleRegistry parent) {
        this((Map<Class<? extends Module>, ModuleRegistry.Entry>)((Object)new CombinedTHashMap<Class<? extends Module>, ModuleRegistry.Entry>(parent.getRegistry())), new CombinedCollection<Module>(parent.getModules()));
    }

    HierarchicModuleRegistry(Map<Class<? extends Module>, ModuleRegistry.Entry> registry, CombinedCollection<Module> modules) {
        super(registry, modules);
        this.modules = modules;
    }

    Iterator<Module> getChildModules() {
        return this.modules.childIterator();
    }

    private static class CombinedTHashMap<K, V>
    extends THashMap<K, V> {
        private final Map<K, V> parent;

        public CombinedTHashMap(Map<K, V> parent) {
            this.parent = parent;
        }

        public CombinedTHashMap() {
            this.parent = Collections.emptyMap();
        }

        public int size() {
            return super.size() + this.parent.size();
        }

        public boolean isEmpty() {
            return super.isEmpty() && this.parent.isEmpty();
        }

        public boolean containsKey(Object key) {
            return super.containsKey(key) || this.parent.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return super.containsValue(value) || this.parent.containsValue(value);
        }

        public V get(Object key) {
            V value = this.parent.get(key);
            return (V)(value != null ? value : super.get(key));
        }

        public Set<K> keySet() {
            return Sets.union(this.parent.keySet(), (Set)super.keySet());
        }

        public Collection<V> values() {
            LinkedList<V> values = new LinkedList<V>(this.parent.values());
            values.addAll(super.values());
            return values;
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return Sets.union(this.parent.entrySet(), (Set)super.entrySet());
        }
    }

    private static class CombinedCollection<E>
    extends LinkedList<E> {
        private final Collection<E> parent;

        public CombinedCollection(Collection<E> parent) {
            this.parent = parent;
        }

        @Override
        public boolean contains(Object o) {
            return this.parent.contains(o) || super.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.parent.containsAll(c) || super.containsAll(c);
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> parentIterator = this.parent.iterator();
            final Iterator childIterator = super.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return parentIterator.hasNext() || childIterator.hasNext();
                }

                @Override
                public E next() {
                    return this.getIterator().next();
                }

                @Override
                public void remove() {
                    this.getIterator().remove();
                }

                private Iterator<E> getIterator() {
                    return !childIterator.hasNext() ? parentIterator : childIterator;
                }
            };
        }

        public Iterator<E> childIterator() {
            return super.iterator();
        }

        @Override
        public int size() {
            return this.parent.size() + super.size();
        }

        @Override
        public boolean isEmpty() {
            return this.parent.isEmpty() && super.isEmpty();
        }

        @Override
        public E get(int index) {
            return index < this.parent.size() ? null : (E)super.get(index);
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            int i = 0;
            for (E e : this) {
                result[i++] = e;
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            T[] result = a;
            int i = 0;
            for (E e : this) {
                result[i++] = e;
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }
    }
}

