/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.mountainblade.modular.Module;
import net.mountainblade.modular.ModuleInformation;
import net.mountainblade.modular.annotations.Inject;
import net.mountainblade.modular.impl.Destroyable;
import net.mountainblade.modular.impl.InjectFailedException;
import net.mountainblade.modular.impl.ModuleRegistry;

public class Injector
extends Destroyable {
    private static final Logger LOG = Logger.getLogger(Injector.class.getName());
    private final Map<Class<? extends Module>, Collection<Entry>> cache;
    private final ModuleRegistry registry;
    private final List<Builder> builders;

    Injector(ModuleRegistry registry) {
        this.registry = registry;
        this.builders = new LinkedList<Builder>();
        this.cache = new ConcurrentHashMap<Class<? extends Module>, Collection<Entry>>();
        this.destroy();
    }

    public <T> Builder<T> inject(Class<T> fieldClass) {
        return new Builder<T>(fieldClass);
    }

    public void inject(ModuleRegistry.Entry moduleEntry) throws InjectFailedException {
        this.inject(moduleEntry.getModule());
    }

    public void inject(Module module) throws InjectFailedException {
        for (Entry entry : this.discover(module.getClass())) {
            if (entry == null) continue;
            entry.apply(module);
        }
    }

    Collection<Entry> discover(Class<? extends Module> moduleClass) {
        Collection<Entry> entries = this.cache.get(moduleClass);
        if (entries == null) {
            entries = new LinkedList<Entry>();
            this.discover(moduleClass, entries, moduleClass.getDeclaredFields());
            for (Class<? extends Module> superClass = moduleClass.getSuperclass(); superClass != null && !superClass.equals(Class.class); superClass = superClass.getSuperclass()) {
                this.discover(moduleClass, entries, superClass.getDeclaredFields());
            }
            this.cache.put(moduleClass, entries);
        }
        return entries;
    }

    private void discover(Class<? extends Module> implementationClass, Collection<Entry> entries, Field[] fields) {
        block2: for (Field field : fields) {
            Inject annotation;
            if (Modifier.isStatic(field.getModifiers()) || (annotation = field.getAnnotation(Inject.class)) == null) continue;
            Class<?> fieldType = field.getType();
            try {
                this.checkModuleField(implementationClass, fieldType);
                boolean added = false;
                ListIterator<Builder> iterator = this.builders.listIterator(this.builders.size());
                while (iterator.hasPrevious()) {
                    boolean useFrom;
                    Builder builder = iterator.previous();
                    if (builder.exactMatch) {
                        if (!builder.fieldClass.equals(fieldType)) continue;
                    } else if (!builder.fieldClass.isAssignableFrom(fieldType)) continue;
                    for (Class annotationClass : builder.annotationClasses) {
                        if (field.getAnnotation(annotationClass) != null) continue;
                        continue block2;
                    }
                    for (Annotation annotationImpl : builder.annotations) {
                        Annotation fieldAnnotation;
                        if (annotationImpl.equals(fieldAnnotation = field.getAnnotation(annotationImpl.annotationType()))) continue;
                        continue block2;
                    }
                    Class<? extends Module> from = annotation.from();
                    boolean bl = useFrom = !from.equals(Inject.Current.class);
                    if (useFrom) {
                        this.checkModuleField(implementationClass, from);
                    }
                    entries.add(new Entry(useFrom ? from : (Module.class.isAssignableFrom(fieldType) ? fieldType : implementationClass), builder, annotation, field, useFrom));
                    added = true;
                }
                if (added) continue;
                throw new InjectFailedException("Dependency is not a module or special type: " + fieldType);
            }
            catch (InjectFailedException e) {
                LOG.log(Level.WARNING, "Error with dependency entry for implementation, injects will fail", e);
            }
        }
    }

    private void checkModuleField(Class<? extends Module> implementationClass, Class<?> fieldType) throws InjectFailedException {
        if (fieldType.equals(Module.class)) {
            throw new InjectFailedException("Cannot inject field with raw Module type");
        }
        if (fieldType.equals(implementationClass.getClass())) {
            throw new InjectFailedException("Cannot inject field with itself (Why would you do that?)");
        }
    }

    @Override
    protected void destroy() {
        this.cache.clear();
        this.builders.clear();
        this.inject(Logger.class).with(new Constructor<Logger>(){

            @Override
            public Logger construct(Inject annotation, Class<? extends Logger> type, Module module) {
                return Logger.getLogger(module.getClass().getName());
            }
        });
        this.inject(Module.class).with(new Constructor<Module>(){

            @Override
            public Module construct(Inject annotation, Class<? extends Module> type, Module module) {
                return Injector.this.registry.getModule(type);
            }
        });
        this.inject(ModuleInformation.class).with(new Constructor<ModuleInformation>(){

            @Override
            public ModuleInformation construct(Inject annotation, Class<? extends ModuleInformation> type, Module module) {
                return Injector.this.registry.getInformation(module.getClass());
            }
        });
    }

    public static interface Constructor<T> {
        public T construct(Inject var1, Class<? extends T> var2, Module var3);
    }

    public class Builder<T> {
        private final Class<T> fieldClass;
        private final Collection<Class<? extends Annotation>> annotationClasses;
        private final Collection<Annotation> annotations;
        private Constructor<? extends T> constructor;
        private boolean nullable;
        private boolean exactMatch;

        Builder(Class<T> fieldClass) {
            this.fieldClass = fieldClass;
            this.annotationClasses = new LinkedList<Class<? extends Annotation>>();
            this.annotations = new LinkedList<Annotation>();
        }

        public void with(final T instance) {
            this.with(new Constructor<T>(){

                @Override
                public T construct(Inject annotation, Class<? extends T> type, Module module) {
                    return instance;
                }
            });
        }

        public void with(Constructor<? extends T> constructor) {
            this.constructor = constructor;
            Injector.this.builders.add(this);
        }

        public Builder<T> nullable() {
            this.nullable = true;
            return this;
        }

        public Builder<T> exactly() {
            this.exactMatch = true;
            return this;
        }

        public Builder<T> marked(Annotation annotation) {
            this.annotations.add(annotation);
            return this;
        }

        public Builder<T> marked(Class<? extends Annotation> annotation) {
            this.annotationClasses.add(annotation);
            return this;
        }
    }

    class Entry {
        private final Class<? extends Module> dependency;
        private final Builder builder;
        private final Inject annotation;
        private final Field field;
        private final boolean useFrom;

        Entry(Class<? extends Module> dependency, Builder builder, Inject annotation, Field field, boolean useFrom) {
            this.dependency = dependency;
            this.builder = builder;
            this.annotation = annotation;
            this.field = field;
            this.useFrom = useFrom;
        }

        public Class<? extends Module> getDependency() {
            return this.dependency;
        }

        private void apply(Module module) throws InjectFailedException {
            Module theModule;
            Module module2 = theModule = this.useFrom ? Injector.this.registry.getModule(this.dependency) : module;
            if (theModule == null) {
                throw new InjectFailedException("Could not get module for " + this.dependency);
            }
            Object object = this.builder.constructor.construct(this.annotation, this.field.getType(), theModule);
            if (object == null) {
                if (!this.annotation.optional() && !this.builder.nullable) {
                    int modifiers = this.field.getModifiers();
                    Type fieldType = this.field.getGenericType();
                    throw new InjectFailedException("Could not inject " + theModule.getClass() + " with null object " + "for field \"" + (modifiers == 0 ? "" : Modifier.toString(modifiers) + " ") + fieldType.getTypeName() + " " + this.field.getName() + '\"');
                }
                return;
            }
            try {
                this.field.setAccessible(true);
                this.field.set(module, object);
            }
            catch (IllegalAccessException e) {
                throw new InjectFailedException("Could not inject " + this.dependency + " with " + this.field.getType(), e);
            }
        }
    }
}

