/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular.impl;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.mountainblade.modular.Module;
import net.mountainblade.modular.ModuleManager;
import net.mountainblade.modular.ModuleState;
import net.mountainblade.modular.annotations.Implementation;
import net.mountainblade.modular.annotations.Initialize;
import net.mountainblade.modular.annotations.Inject;
import net.mountainblade.modular.annotations.Requires;
import net.mountainblade.modular.impl.Annotations;
import net.mountainblade.modular.impl.BaseModuleManager;
import net.mountainblade.modular.impl.Destroyable;
import net.mountainblade.modular.impl.InjectFailedException;
import net.mountainblade.modular.impl.Injector;
import net.mountainblade.modular.impl.ModuleInformationImpl;
import net.mountainblade.modular.impl.ModuleRegistry;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.strategy.OsgiBundleStrategy;
import org.codehaus.plexus.classworlds.strategy.ParentFirstStrategy;
import org.codehaus.plexus.classworlds.strategy.SelfFirstStrategy;
import org.codehaus.plexus.classworlds.strategy.Strategy;

public final class ModuleLoader
extends Destroyable {
    private static final Logger LOG = Logger.getLogger(ModuleLoader.class.getName());
    private static final Map<Class<?>, ClassEntry> CLASS_CACHE = new THashMap();
    private static final Collection<Class<?>> INVALID_CACHE = new THashSet();
    private final ClassRealm realm;
    private final ModuleRegistry registry;
    private final Injector injector;
    private final Collection<Class<?>> ignores;

    public ModuleLoader(ClassRealm realm, ModuleRegistry registry, Injector injector) {
        this.realm = realm;
        this.registry = registry;
        this.injector = injector;
        this.ignores = new THashSet();
        this.setLoadingStrategy(ParentFirstStrategy.class);
    }

    public ClassRealm getRealm() {
        return this.realm;
    }

    public void setLoadingStrategy(Class<? extends Strategy> strategyClass) {
        if (ParentFirstStrategy.class.equals(strategyClass)) {
            this.setLoadingStrategy((Strategy)new ParentFirstStrategy(this.getRealm()));
        } else if (SelfFirstStrategy.class.equals(strategyClass)) {
            this.setLoadingStrategy((Strategy)new SelfFirstStrategy(this.getRealm()));
        } else if (OsgiBundleStrategy.class.equals(strategyClass)) {
            this.setLoadingStrategy((Strategy)new OsgiBundleStrategy(this.getRealm()));
        }
    }

    public void setLoadingStrategy(Strategy strategy) {
        for (Field field : this.realm.getClass().getDeclaredFields()) {
            if (!Strategy.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                field.set(this.realm, strategy);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.WARNING, "Could not set class realm loading strategy (using reflection)", e);
            }
            return;
        }
    }

    public boolean ignoreModuleClass(Class<? extends Module> ignore) {
        return this.ignores.add(ignore);
    }

    Collection<ClassEntry> filter(BaseModuleManager manager, Map<URI, Collection<String>> classNames, Collection<String> list) {
        TLinkedHashSet candidates = new TLinkedHashSet();
        LinkedList<ClassEntry> moduleClasses = new LinkedList<ClassEntry>();
        for (Map.Entry<URI, Collection<String>> entry : classNames.entrySet()) {
            boolean hasValidModule = false;
            for (String className : entry.getValue()) {
                if (!list.contains(className)) continue;
                try {
                    Class aClass = this.realm.loadClass(className);
                    if (!this.isValidModuleClass(aClass)) continue;
                    hasValidModule = true;
                    candidates.add(aClass);
                }
                catch (ClassNotFoundException e1) {
                    LOG.log(Level.WARNING, "Could not load class: " + className, e1);
                }
                catch (NoClassDefFoundError e) {
                    if (BaseModuleManager.thoroughSearchEnabled() || BaseModuleManager.includedFullClassPath) continue;
                    LOG.log(Level.INFO, "Could not load class that was available at compile time for: " + className + "! This often seems to be a problem with shading, please check the classes / build script", e);
                }
                catch (SecurityException e2) {
                    LOG.log(Level.WARNING, "Could not load class due to security exception: " + className, e2);
                }
            }
            if (hasValidModule) continue;
            manager.blacklist(entry.getKey());
        }
        for (Class candidate : candidates) {
            ClassEntry classEntry;
            if (this.candidateIsObsolete(candidate, (Collection<Class<? extends Module>>)candidates) || (classEntry = this.getClassEntry(candidate)) == null) continue;
            moduleClasses.add(classEntry);
        }
        return moduleClasses;
    }

    boolean isValidModuleClass(Class<?> aClass) {
        return !aClass.isInterface() && !Module.class.equals(aClass) && Module.class.isAssignableFrom(aClass);
    }

    private boolean candidateIsObsolete(Class<? extends Module> candidate, Collection<Class<? extends Module>> others) {
        for (Class<? extends Module> other : others) {
            if (other.getSuperclass() != candidate) continue;
            return true;
        }
        return false;
    }

    public Module loadModule(ModuleManager moduleManager, ClassEntry classEntry) {
        if (classEntry == null) {
            LOG.warning("Tried to load invalid module");
            return null;
        }
        Module module = this.registry.getModule(classEntry.getImplementation());
        if (module != null) {
            return module;
        }
        ModuleInformationImpl information = new ModuleInformationImpl(classEntry.getAnnotation());
        ModuleRegistry.Entry moduleEntry = this.registry.createEntry(classEntry.getModule(), information);
        this.registry.addModule(classEntry.getImplementation(), moduleEntry, true);
        try {
            Constructor<? extends Module> constructor = classEntry.getImplementation().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            module = constructor.newInstance(new Object[0]);
            this.injectAndInitialize(moduleManager, module, information);
            this.registerEntry(classEntry, module, information, moduleEntry);
            return module;
        }
        catch (NoSuchMethodException e) {
            LOG.log(Level.WARNING, "Could not find module constructor", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.log(Level.WARNING, "Could not instantiate module implementation", e);
        }
        return null;
    }

    public void injectAndInitialize(ModuleManager manager, Module module, ModuleInformationImpl information) {
        try {
            information.setState(ModuleState.LOADING);
            this.injector.inject(module);
            Annotations.call(module, Initialize.class, 0, new Class[]{ModuleManager.class}, manager);
        }
        catch (InjectFailedException e) {
            throw new RuntimeException("Could not load module implementation", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Could not call initialize method on module implementation", e);
        }
    }

    public void registerEntry(ClassEntry classEntry, Module module, ModuleInformationImpl information, ModuleRegistry.Entry moduleEntry) {
        information.setState(ModuleState.READY);
        moduleEntry.setModule(module);
        this.registry.addModule(classEntry.getModule(), moduleEntry, false);
    }

    public ClassEntry getClassEntry(Class<? extends Module> implClass) {
        if (implClass == null || Module.class.equals(implClass) || Implementation.Default.class.equals(implClass) || Inject.Current.class.equals(implClass) || INVALID_CACHE.contains(implClass)) {
            return null;
        }
        ClassEntry classEntry = CLASS_CACHE.get(implClass);
        if (classEntry == null) {
            Class<? extends Module> module;
            if (implClass.isInterface() || implClass.isAnnotation()) {
                INVALID_CACHE.add(implClass);
                return null;
            }
            Implementation implementation = implClass.getAnnotation(Implementation.class);
            if (implementation == null) {
                INVALID_CACHE.add(implClass);
                return null;
            }
            if (!implementation.module().equals(Implementation.Default.class)) {
                module = implementation.module();
            } else {
                module = this.getModuleClassRecursively(implClass);
                if (module == null) {
                    INVALID_CACHE.add(implClass);
                    return null;
                }
            }
            LinkedList<Class<? extends Module>> requirements = new LinkedList<Class<? extends Module>>();
            this.getRequirementsRecursively(implClass, requirements);
            classEntry = new ClassEntry(module, implClass, implementation, this.injector.discover(implClass), requirements);
            CLASS_CACHE.put(implClass, classEntry);
            CLASS_CACHE.put(module, classEntry);
        }
        return classEntry;
    }

    private void getRequirementsRecursively(Class<?> aClass, Collection<Class<? extends Module>> list) {
        Requires[] requirements = (Requires[])aClass.getDeclaredAnnotationsByType(Requires.class);
        for (Requires requirement : requirements) {
            list.addAll(Arrays.asList(requirement.value()));
        }
        for (Class<?> entry : aClass.getInterfaces()) {
            if (entry == Module.class || this.ignores.contains(entry)) continue;
            this.getRequirementsRecursively(entry, list);
        }
        Class<?> parent = aClass.getSuperclass();
        if (parent != null && parent != Object.class && parent != Module.class && !this.ignores.contains(parent)) {
            this.getRequirementsRecursively(parent, list);
        }
    }

    @Override
    protected void destroy() {
        this.injector.destroy();
    }

    private Class<? extends Module> getModuleClassRecursively(Class<?> aClass) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = aClass.getInterfaces()) {
            Class<? extends Module> recursiveLookup;
            if (!Module.class.isAssignableFrom(anInterface)) continue;
            if (this.ignores.contains(anInterface) && (recursiveLookup = this.getModuleClassRecursively(anInterface)) != null) {
                return recursiveLookup;
            }
            if (!aClass.isInterface() && Module.class.equals(anInterface)) {
                return aClass;
            }
            return anInterface;
        }
        return this.getModuleClassRecursively(aClass.getSuperclass());
    }

    public static final class ClassEntry {
        private final Class<? extends Module> module;
        private final Class<? extends Module> implementation;
        private final Implementation annotation;
        private final Collection<Injector.Entry> dependencies;
        private final Collection<Class<? extends Module>> requirements;

        private ClassEntry(Class<? extends Module> module, Class<? extends Module> implementation, Implementation annotation, Collection<Injector.Entry> dependencies, Collection<Class<? extends Module>> requirements) {
            this.module = module;
            this.implementation = implementation;
            this.annotation = annotation;
            this.dependencies = dependencies;
            this.requirements = requirements;
        }

        public Class<? extends Module> getModule() {
            return this.module;
        }

        public Class<? extends Module> getImplementation() {
            return this.implementation;
        }

        public Implementation getAnnotation() {
            return this.annotation;
        }

        public Collection<Injector.Entry> getDependencies() {
            return this.dependencies;
        }

        public Collection<Class<? extends Module>> getRequirements() {
            return this.requirements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassEntry)) {
                return false;
            }
            ClassEntry that = (ClassEntry)o;
            return this.annotation.equals(that.annotation) && this.dependencies.equals(that.dependencies) && this.requirements.equals(that.requirements) && this.implementation.equals(that.implementation) && this.module.equals(that.module);
        }

        public int hashCode() {
            return 31 * (31 * (31 * this.module.hashCode() + this.implementation.hashCode()) + this.annotation.hashCode()) + this.dependencies.hashCode() + this.requirements.hashCode();
        }

        public String toString() {
            return "ClassEntry{module=" + this.module + ", implementation=" + this.implementation + ", annotation=" + this.annotation + ", dependencies=" + this.dependencies + ", requirements=" + this.requirements + '}';
        }
    }
}

