/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import net.mountainblade.modular.Module;
import net.mountainblade.modular.ModuleInformation;
import net.mountainblade.modular.ModuleState;
import net.mountainblade.modular.impl.Destroyable;

public class ModuleRegistry
extends Destroyable {
    private final Map<Class<? extends Module>, Entry> registry;
    private final Collection<Module> modules;

    ModuleRegistry(Map<Class<? extends Module>, Entry> registry, Collection<Module> modules) {
        this.registry = registry;
        this.modules = modules;
    }

    public <M extends Module> M getModule(Class<M> moduleClass) {
        Entry entry = this.getEntry(moduleClass);
        return (M)(entry == null ? null : entry.getModule());
    }

    public ModuleInformation getInformation(Class<? extends Module> moduleClass) {
        Entry entry = this.getEntry(moduleClass);
        return entry == null ? null : entry.getInformation();
    }

    public Collection<Module> getModules() {
        return Collections.unmodifiableCollection(this.modules);
    }

    public Collection<Module> getModules(ModuleState state) {
        LinkedList<Module> modules = new LinkedList<Module>();
        for (Module module : this.getModules()) {
            ModuleInformation information = this.getInformation(module.getClass());
            if (!state.equals((Object)information.getState())) continue;
            modules.add(module);
        }
        return Collections.unmodifiableCollection(modules);
    }

    protected void addGhostModule(Class<? extends Module> moduleClass, Module module, ModuleInformation information) {
        Entry entry = new Entry(information, moduleClass);
        entry.setModule(module);
        this.addModule(moduleClass, entry, true);
    }

    protected void addModule(Class<? extends Module> moduleClass, Entry entry, boolean ghost) {
        this.registry.put(moduleClass, entry);
        if (!ghost) {
            this.modules.add(entry.getModule());
        }
    }

    protected Entry createEntry(Class<? extends Module> moduleClass, ModuleInformation information) {
        if (moduleClass == null) {
            return null;
        }
        Entry entry = new Entry(information, moduleClass);
        this.registry.put(moduleClass, entry);
        return entry;
    }

    protected Entry getEntry(Class<? extends Module> moduleClass) {
        return moduleClass == null ? null : this.registry.get(moduleClass);
    }

    @Override
    protected void destroy() {
        this.registry.clear();
        this.modules.clear();
    }

    protected Map<Class<? extends Module>, Entry> getRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }

    public static final class Entry {
        private final ModuleInformation information;
        private final Class<? extends Module> moduleClass;
        private Module module;

        private Entry(ModuleInformation information, Class<? extends Module> moduleClass) {
            this.information = information;
            this.moduleClass = moduleClass;
        }

        public ModuleInformation getInformation() {
            return this.information;
        }

        public Class<? extends Module> getModuleClass() {
            return this.moduleClass;
        }

        public Module getModule() {
            return this.module;
        }

        void setModule(Module module) {
            this.module = module;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.information.equals(entry.information) && !(this.module == null ? entry.module != null : !this.module.equals(entry.module)) && this.moduleClass.equals(entry.moduleClass);
        }

        public int hashCode() {
            return 31 * (31 * (31 * this.information.hashCode() + this.moduleClass.hashCode()) + (this.module != null ? this.module.hashCode() : 0));
        }

        public String toString() {
            return "Entry{information=" + this.information + ", moduleClass=" + this.moduleClass + ", module=" + this.module + '}';
        }
    }
}

