/*
 * Decompiled with CFR 0.152.
 */
package net.mountainblade.modular.impl;

import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.list.TLinkable;
import gnu.trove.list.TLinkableAdapter;
import gnu.trove.list.linked.TLinkedList;
import gnu.trove.set.hash.THashSet;

public class TopologicalSortedList<E>
extends TLinkedList<Node<E>> {
    public Node<E> addNode(E element) {
        Node<E> node = new Node<E>(element);
        super.add(node);
        return node;
    }

    public void sort() throws CycleException {
        THashSet noEdges = new THashSet();
        Node[] allNodes = (Node[])super.toArray((Object[])new Node[this.size()]);
        Node[] nodeArray = this.iterator();
        while (nodeArray.hasNext()) {
            Node n = (Node)((Object)nodeArray.next());
            if (n.inEdges.size() != 0) continue;
            noEdges.add((Object)n);
        }
        this.clear();
        while (!noEdges.isEmpty()) {
            Node n = (Node)((Object)noEdges.iterator().next());
            noEdges.remove((Object)n);
            this.add((TLinkable)n);
            TObjectHashIterator it = n.outerEdges.iterator();
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                Node m = e.to;
                it.remove();
                m.inEdges.remove((Object)e);
                if (!m.inEdges.isEmpty()) continue;
                noEdges.add((Object)m);
            }
        }
        for (Node n : allNodes) {
            if (n.inEdges.isEmpty() && n.outerEdges.isEmpty()) continue;
            throw new CycleException("Cycle found in list: " + (Object)((Object)this));
        }
    }

    public static class CycleException
    extends Exception {
        public CycleException(String message) {
            super(message);
        }
    }

    protected static class Edge<E> {
        private final Node<E> from;
        private final Node<E> to;

        public Edge(Node<E> from, Node<E> to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class Node<E>
    extends TLinkableAdapter<Node<E>> {
        private final THashSet<Edge<E>> inEdges;
        private final THashSet<Edge<E>> outerEdges;
        private final E value;

        public Node(E value) {
            this.value = value;
            this.inEdges = new THashSet();
            this.outerEdges = new THashSet();
        }

        public Node<E> isRequiredBefore(Node<E> node) {
            Edge<E> e = new Edge<E>(this, node);
            this.outerEdges.add(e);
            node.inEdges.add(e);
            return this;
        }

        public Node<E> isRequiredBefore(E element) {
            return this.isRequiredBefore((E)((Object)new Node<E>(element)));
        }

        public E getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

