/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.random.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.moznion.random.string.Letter;

class RandomLetterPicker {
    private final List<String> letters;
    private final int size;
    private final Random random;

    public static Builder builder() {
        return new Builder();
    }

    private RandomLetterPicker(Builder b) {
        this.letters = Collections.unmodifiableList(b.getLetters());
        this.random = b.getRandom() == null ? new Random() : b.getRandom();
        this.size = this.letters.size();
    }

    public String pickRandomLetter() {
        return this.letters.get(this.random.nextInt(this.size));
    }

    public static RandomLetterPicker constructByCharacterRange(List<String> bounds) {
        Builder definedPickerBuilder = RandomLetterPicker.builder();
        int bufferSize = bounds.size();
        for (int i = 0; i < bufferSize; i += 2) {
            char endCode;
            int beginCode = bounds.get(i).charAt(0);
            if (beginCode > (endCode = bounds.get(i + 1).charAt(0))) {
                throw new RuntimeException("Detected invalid character range: [" + (char)beginCode + "-" + (char)endCode + "]");
            }
            for (int code = beginCode; code <= endCode; ++code) {
                definedPickerBuilder.add(String.valueOf((char)code));
            }
        }
        return definedPickerBuilder.build();
    }

    public static class Builder {
        private List<String> letters = new ArrayList<String>();
        private Random random = null;

        public <E extends Enum<E>> Builder addAllByEnum(Class<E> enumClass) {
            this.letters.addAll(Arrays.stream(enumClass.getEnumConstants()).map(e -> ((Letter)((Object)e)).getLetter()).collect(Collectors.toList()));
            return this;
        }

        public Builder addAll(List<String> list) {
            this.letters.addAll(list);
            return this;
        }

        public Builder add(String letter) {
            this.letters.add(letter);
            return this;
        }

        public Builder remove(String remove) {
            this.letters = this.letters.stream().filter(l -> !l.equals(remove)).collect(Collectors.toList());
            return this;
        }

        public Builder setRandom(Random random) {
            this.random = random;
            return this;
        }

        public RandomLetterPicker build() {
            return new RandomLetterPicker(this);
        }

        public List<String> getLetters() {
            return this.letters;
        }

        public Random getRandom() {
            return this.random;
        }
    }
}

