/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.random.string;

import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.moznion.random.string.DigitLetter;
import net.moznion.random.string.LowerCaseLetter;
import net.moznion.random.string.RandomLetterPicker;
import net.moznion.random.string.SymbolLetter;
import net.moznion.random.string.UpperCaseLetter;

class RandomLetterPickers {
    private final RandomLetterPicker upperCase;
    private final RandomLetterPicker lowerCase;
    private final RandomLetterPicker digit;
    private final RandomLetterPicker symbol;
    private final RandomLetterPicker any;
    private final RandomLetterPicker salt;
    private final RandomLetterPicker binary;
    private final RandomLetterPicker word;
    private final RandomLetterPicker notWord;
    private final RandomLetterPicker notDigit;
    private final RandomLetterPicker space;

    public RandomLetterPickers(Random random) {
        this.upperCase = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).build();
        this.lowerCase = RandomLetterPicker.builder().setRandom(random).addAllByEnum(LowerCaseLetter.class).build();
        this.digit = RandomLetterPicker.builder().setRandom(random).addAllByEnum(DigitLetter.class).build();
        this.symbol = RandomLetterPicker.builder().setRandom(random).addAllByEnum(SymbolLetter.class).build();
        this.any = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).addAllByEnum(LowerCaseLetter.class).addAllByEnum(DigitLetter.class).addAllByEnum(SymbolLetter.class).build();
        this.salt = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).addAllByEnum(LowerCaseLetter.class).addAllByEnum(DigitLetter.class).add(".").add("/").build();
        this.binary = RandomLetterPicker.builder().setRandom(random).addAll(IntStream.range(0, 255).mapToObj(i -> Character.toString((char)i)).collect(Collectors.toList())).build();
        this.word = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).addAllByEnum(LowerCaseLetter.class).addAllByEnum(DigitLetter.class).add("_").build();
        this.notWord = RandomLetterPicker.builder().setRandom(random).addAllByEnum(SymbolLetter.class).remove("_").build();
        this.notDigit = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).addAllByEnum(LowerCaseLetter.class).addAllByEnum(SymbolLetter.class).build();
        this.space = RandomLetterPicker.builder().setRandom(random).add(" ").add("\t").build();
    }

    public RandomLetterPicker getUpperCase() {
        return this.upperCase;
    }

    public RandomLetterPicker getLowerCase() {
        return this.lowerCase;
    }

    public RandomLetterPicker getDigit() {
        return this.digit;
    }

    public RandomLetterPicker getSymbol() {
        return this.symbol;
    }

    public RandomLetterPicker getAny() {
        return this.any;
    }

    public RandomLetterPicker getSalt() {
        return this.salt;
    }

    public RandomLetterPicker getBinary() {
        return this.binary;
    }

    public RandomLetterPicker getWord() {
        return this.word;
    }

    public RandomLetterPicker getNotWord() {
        return this.notWord;
    }

    public RandomLetterPicker getNotDigit() {
        return this.notDigit;
    }

    public RandomLetterPicker getSpace() {
        return this.space;
    }
}

