/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.i18n.autoconfigure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.n2oapp.platform.i18n.Messages;
import net.n2oapp.platform.i18n.autoconfigure.I18nProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.context.MessageSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
public class I18nAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MessageSourceAccessor messageSourceAccessor(MessageSource messageSource) {
        return new MessageSourceAccessor(messageSource);
    }

    @Bean
    @ConditionalOnMissingBean
    Messages messages(MessageSourceAccessor messageSourceAccessor) {
        return new Messages(messageSourceAccessor);
    }

    @Configuration
    @ConditionalOnProperty(prefix="i18n", name={"global.enabled"}, matchIfMissing=true)
    @EnableConfigurationProperties(value={I18nProperties.class})
    public static class GlobalMessageSourceConfiguration {
        private I18nProperties i18nProperties;

        @Bean
        @ConfigurationProperties(prefix="spring.messages")
        public MessageSourceProperties messageSourceProperties() {
            return new MessageSourceProperties();
        }

        public GlobalMessageSourceConfiguration(I18nProperties i18nProperties) {
            this.i18nProperties = i18nProperties;
        }

        @Bean
        MessageSource messageSource() throws IOException {
            ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
            ArrayList<String> baseNames = new ArrayList<String>();
            if (StringUtils.hasText((String)this.messageSourceProperties().getBasename())) {
                baseNames.addAll(StringUtils.commaDelimitedListToSet((String)StringUtils.trimAllWhitespace((String)this.messageSourceProperties().getBasename())));
            }
            baseNames.addAll(this.scanBaseNames(this.i18nProperties.getGlobal().getPackageName()));
            messageSource.setBasenames(baseNames.toArray(new String[baseNames.size()]));
            if (this.messageSourceProperties().getEncoding() != null) {
                messageSource.setDefaultEncoding(this.messageSourceProperties().getEncoding().name());
            }
            messageSource.setFallbackToSystemLocale(this.messageSourceProperties().isFallbackToSystemLocale());
            Optional.ofNullable(this.messageSourceProperties().getCacheDuration()).ifPresent(duration -> messageSource.setCacheSeconds((int)duration.toSeconds()));
            messageSource.setAlwaysUseMessageFormat(this.messageSourceProperties().isAlwaysUseMessageFormat());
            return messageSource;
        }

        private Set<String> scanBaseNames(String packageName) throws IOException {
            Resource[] resources;
            HashSet<String> baseNames = new HashSet<String>();
            Object pack = !packageName.endsWith("/") ? packageName + "/" : packageName;
            PathMatchingResourcePatternResolver r = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = r.getResources("classpath*:" + (String)pack + "*.properties")) {
                int endIdx = resource.getFilename().indexOf(95);
                if (endIdx < 0) {
                    endIdx = resource.getFilename().indexOf(".properties");
                }
                baseNames.add((String)pack + resource.getFilename().substring(0, endIdx));
            }
            return baseNames;
        }
    }
}

