/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.i18n;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;

public class Message {
    private String code;
    private Object[] args;

    public Message(String code) {
        this.code = code;
    }

    public Message(String code, Object ... args) {
        this.code = code;
        this.args = args;
    }

    public Message set(Object argument) {
        ArrayList list = new ArrayList(this.args != null ? Arrays.asList(this.args) : Collections.emptyList());
        list.add(argument);
        this.args = list.toArray();
        return this;
    }

    public String getMessage(MessageSourceAccessor messageSourceAccessor) {
        return messageSourceAccessor.getMessage(this.code, this.args);
    }

    public String getMessage(MessageSource messageSource) {
        return new MessageSourceAccessor(messageSource).getMessage(this.code, this.args);
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String toString() {
        return this.code + "{" + Arrays.toString(this.args) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.code, message.code) && Arrays.equals(this.args, message.args);
    }

    public int hashCode() {
        int result = Objects.hash(this.code);
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }
}

