/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@Provider(value=Provider.Type.InInterceptor)
public class JaxRsAcceptHeaderSorter
extends AbstractPhaseInterceptor<Message> {
    public JaxRsAcceptHeaderSorter() {
        super("receive");
    }

    public void handleMessage(Message message) {
        this.processAcceptHeader(message);
        this.processProtocolHeaders(message);
    }

    private void processProtocolHeaders(Message message) {
        Object protocolHeaders = message.get((Object)Message.PROTOCOL_HEADERS);
        if (!(protocolHeaders instanceof Map)) {
            return;
        }
        Map headers = (Map)protocolHeaders;
        Object accept = headers.get("Accept");
        if (!(accept instanceof List)) {
            return;
        }
        List list = (List)accept;
        this.processListOfAcceptHeaders(list);
    }

    private void processListOfAcceptHeaders(List<Object> headers) {
        if (!headers.isEmpty()) {
            ListIterator<Object> iterator = headers.listIterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof String)) continue;
                String s = this.sort((String)next);
                iterator.set(s);
            }
        }
    }

    private void processAcceptHeader(Message message) {
        Object o = message.get((Object)"Accept");
        if (o instanceof String && !((String)o).isBlank()) {
            message.put((Object)"Accept", (Object)this.sort((String)o));
        }
    }

    private String sort(String accept) {
        CharSequence[] split = accept.split(",");
        Arrays.sort(split, (s1, s2) -> {
            boolean s1Xml = StringUtils.containsIgnoreCase((CharSequence)s1, (CharSequence)"xml");
            boolean s2Xml = StringUtils.containsIgnoreCase((CharSequence)s2, (CharSequence)"xml");
            if (s1Xml && !s2Xml) {
                return 1;
            }
            if (!s1Xml && s2Xml) {
                return -1;
            }
            return 0;
        });
        return String.join((CharSequence)",", split);
    }
}

