/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import brave.Tracing;
import net.n2oapp.platform.jaxrs.autoconfigure.JaxRsProxyClientRegistrar;
import net.n2oapp.platform.jaxrs.autoconfigure.RestClientExceptionMapper;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.spring.boot.autoconfigure.CxfAutoConfiguration;
import org.apache.cxf.tracing.brave.jaxrs.BraveClientProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@ConditionalOnClass(value={Client.class})
@AutoConfigureBefore(value={CxfAutoConfiguration.class})
public class JaxRsClientAutoConfiguration {
    @Bean
    RestClientExceptionMapper restClientExceptionMapper() {
        return new RestClientExceptionMapper();
    }

    @Bean
    @ConditionalOnProperty(value={"management.tracing.enabled"})
    BraveClientProvider braveClientProvider(Tracing brave) {
        return new BraveClientProvider(brave);
    }

    @Configuration
    @ConditionalOnProperty(prefix="cxf.jaxrs.client", name={"classes-scan"}, havingValue="true")
    @Import(value={JaxRsProxyClientRegistrar.class})
    static class JaxRsProxyClientScanAutoConfiguration {
        JaxRsProxyClientScanAutoConfiguration() {
        }
    }
}

