/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import io.swagger.v3.oas.models.security.Scopes;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="jaxrs")
public class JaxRsProperties {
    private Logging loggingIn = new Logging();
    private Logging loggingOut = new Logging();
    private boolean jsr303 = true;
    private final OpenApi openapi = new OpenApi();

    public OpenApi getOpenapi() {
        return this.openapi;
    }

    public Logging getLoggingIn() {
        return this.loggingIn;
    }

    public Logging getLoggingOut() {
        return this.loggingOut;
    }

    public boolean isJsr303() {
        return this.jsr303;
    }

    public void setJsr303(boolean jsr303) {
        this.jsr303 = jsr303;
    }

    public static class Logging {
        private boolean enabled = true;
        private int limit = -1;
        private long inMemThreshold = 102400L;
        private boolean prettyLogging;
        private boolean logBinary;
        private boolean logMultipart = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public long getInMemThreshold() {
            return this.inMemThreshold;
        }

        public void setInMemThreshold(long inMemThreshold) {
            this.inMemThreshold = inMemThreshold;
        }

        public boolean isPrettyLogging() {
            return this.prettyLogging;
        }

        public void setPrettyLogging(boolean prettyLogging) {
            this.prettyLogging = prettyLogging;
        }

        public boolean isLogBinary() {
            return this.logBinary;
        }

        public void setLogBinary(boolean logBinary) {
            this.logBinary = logBinary;
        }

        public boolean isLogMultipart() {
            return this.logMultipart;
        }

        public void setLogMultipart(boolean logMultipart) {
            this.logMultipart = logMultipart;
        }
    }

    public static class OpenApi {
        private boolean enabled = true;
        private String title;
        private String description;
        private String version;
        private String[] resourcePackages;
        private Auth auth;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public String[] getResourcePackages() {
            return this.resourcePackages;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setResourcePackages(String[] resourcePackages) {
            this.resourcePackages = resourcePackages;
        }

        public Auth getAuth() {
            return this.auth;
        }

        public void setAuth(Auth auth) {
            this.auth = auth;
        }

        public static class Auth {
            private String name;
            private String tokenUri;
            private String authorizationUri;
            private String refreshUri;
            private Scopes scopes = new Scopes();
            private String flow = "password";

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getTokenUri() {
                return this.tokenUri;
            }

            public void setTokenUri(String tokenUri) {
                this.tokenUri = tokenUri;
            }

            public String getFlow() {
                return this.flow;
            }

            public void setFlow(String flow) {
                this.flow = flow;
            }

            public String getAuthorizationUri() {
                return this.authorizationUri;
            }

            public void setAuthorizationUri(String authorizationUri) {
                this.authorizationUri = authorizationUri;
            }

            public String getRefreshUri() {
                return this.refreshUri;
            }

            public void setRefreshUri(String refreshUri) {
                this.refreshUri = refreshUri;
            }

            public Scopes getScopes() {
                return this.scopes;
            }

            public void setScopes(List<Scope> scopes) {
                this.scopes.clear();
                this.scopes.putAll(scopes.stream().collect(Collectors.toMap(a -> a.key, a -> a.description)));
            }

            public record Scope(String key, String description) {
            }
        }
    }
}

