/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.autoconfigure;

import brave.Tracing;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import jakarta.validation.ValidatorFactory;
import java.util.Map;
import java.util.Set;
import net.n2oapp.platform.i18n.Messages;
import net.n2oapp.platform.jaxrs.MessageExceptionMapper;
import net.n2oapp.platform.jaxrs.ViolationRestExceptionMapper;
import net.n2oapp.platform.jaxrs.autoconfigure.AnnotatedLoggingInInterceptor;
import net.n2oapp.platform.jaxrs.autoconfigure.AnnotatedLoggingOutInterceptor;
import net.n2oapp.platform.jaxrs.autoconfigure.JaxRsAcceptHeaderSorter;
import net.n2oapp.platform.jaxrs.autoconfigure.JaxRsProperties;
import net.n2oapp.platform.jaxrs.autoconfigure.RestServerExceptionMapper;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.openapi.OpenApiFeature;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiConfig;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.spring.boot.autoconfigure.CxfAutoConfiguration;
import org.apache.cxf.spring.boot.autoconfigure.CxfProperties;
import org.apache.cxf.tracing.brave.jaxrs.BraveFeature;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.cxf.validation.BeanValidationInInterceptor;
import org.apache.cxf.validation.BeanValidationProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnClass(value={SpringBus.class, CXFServlet.class})
@AutoConfigureBefore(value={CxfAutoConfiguration.class})
@EnableConfigurationProperties(value={JaxRsProperties.class})
public class JaxRsServerAutoConfiguration {
    private final JaxRsProperties jaxRsProperties;
    private final CxfProperties cxfProperties;

    public JaxRsServerAutoConfiguration(CxfProperties cxfProperties, JaxRsProperties jaxRsProperties) {
        this.cxfProperties = cxfProperties;
        this.jaxRsProperties = jaxRsProperties;
    }

    @Bean(value={"openApiFeature"})
    @ConditionalOnProperty(prefix="jaxrs.openapi", name={"enabled"}, matchIfMissing=true)
    OpenApiFeature openApiFeature() {
        OpenApiFeature feature = new OpenApiFeature();
        feature.setTitle(this.jaxRsProperties.getOpenapi().getTitle());
        feature.setDescription(this.jaxRsProperties.getOpenapi().getDescription());
        feature.setVersion(this.jaxRsProperties.getOpenapi().getVersion());
        feature.setPrettyPrint(true);
        JaxRsProperties.OpenApi.Auth auth = this.jaxRsProperties.getOpenapi().getAuth();
        if (auth != null && auth.getName() != null && auth.getTokenUri() != null) {
            SecurityScheme securityScheme = JaxRsServerAutoConfiguration.getSecurityScheme(auth);
            feature.setSecurityDefinitions(Map.of(auth.getName(), securityScheme));
        }
        if (this.jaxRsProperties.getOpenapi().getResourcePackages() != null) {
            feature.setResourcePackages(Set.of(this.jaxRsProperties.getOpenapi().getResourcePackages()));
        }
        feature.setScan(true);
        SwaggerUiConfig swaggerUiConfig = new SwaggerUiConfig();
        swaggerUiConfig.setQueryConfigEnabled(Boolean.valueOf(false));
        swaggerUiConfig.setUrl("openapi.json");
        feature.setSwaggerUiConfig(swaggerUiConfig);
        return feature;
    }

    private static SecurityScheme getSecurityScheme(JaxRsProperties.OpenApi.Auth auth) {
        OAuthFlows oAuthFlows = new OAuthFlows();
        OAuthFlow oAuthFlow = new OAuthFlow().refreshUrl(auth.getRefreshUri()).scopes(auth.getScopes());
        switch (auth.getFlow()) {
            case "implicit": {
                oAuthFlows.setImplicit(oAuthFlow.authorizationUrl(auth.getAuthorizationUri()));
                break;
            }
            case "password": {
                oAuthFlows.setPassword(oAuthFlow.tokenUrl(auth.getTokenUri()));
                break;
            }
            case "clientCredentials": {
                oAuthFlows.setClientCredentials(oAuthFlow.tokenUrl(auth.getTokenUri()));
                break;
            }
            case "authorizationCode": {
                oAuthFlows.setAuthorizationCode(oAuthFlow.authorizationUrl(auth.getAuthorizationUri()).tokenUrl(auth.getTokenUri()));
            }
        }
        return new SecurityScheme().flows(oAuthFlows).type(SecurityScheme.Type.OAUTH2);
    }

    @Bean
    @ConditionalOnProperty(prefix="jaxrs", name={"log-in", "logging-in.enabled"}, matchIfMissing=true)
    LoggingInInterceptor loggingInInterceptor() {
        AnnotatedLoggingInInterceptor loggingInInterceptor = new AnnotatedLoggingInInterceptor();
        loggingInInterceptor.setLimit(this.jaxRsProperties.getLoggingIn().getLimit());
        loggingInInterceptor.setInMemThreshold(this.jaxRsProperties.getLoggingIn().getInMemThreshold());
        loggingInInterceptor.setLogBinary(this.jaxRsProperties.getLoggingIn().isLogBinary());
        loggingInInterceptor.setLogMultipart(this.jaxRsProperties.getLoggingIn().isLogMultipart());
        loggingInInterceptor.setPrettyLogging(this.jaxRsProperties.getLoggingIn().isPrettyLogging());
        return loggingInInterceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="jaxrs", name={"log-out", "logging-out.enabled"}, matchIfMissing=true)
    LoggingOutInterceptor loggingOutInterceptor() {
        AnnotatedLoggingOutInterceptor loggingOutInterceptor = new AnnotatedLoggingOutInterceptor();
        loggingOutInterceptor.setLimit(this.jaxRsProperties.getLoggingOut().getLimit());
        loggingOutInterceptor.setInMemThreshold(this.jaxRsProperties.getLoggingOut().getInMemThreshold());
        loggingOutInterceptor.setLogBinary(this.jaxRsProperties.getLoggingOut().isLogBinary());
        loggingOutInterceptor.setLogMultipart(this.jaxRsProperties.getLoggingOut().isLogMultipart());
        loggingOutInterceptor.setPrettyLogging(this.jaxRsProperties.getLoggingOut().isPrettyLogging());
        return loggingOutInterceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="jaxrs", name={"jsr303"}, matchIfMissing=true)
    BeanValidationInInterceptor beanValidationInInterceptor(ValidatorFactory validatorFactory) {
        JAXRSBeanValidationInInterceptor validationInInterceptor = new JAXRSBeanValidationInInterceptor();
        BeanValidationProvider validationProvider = new BeanValidationProvider(validatorFactory);
        validationInInterceptor.setProvider(validationProvider);
        return validationInInterceptor;
    }

    @Bean
    ViolationRestExceptionMapper violationExceptionMapper() {
        return new ViolationRestExceptionMapper();
    }

    @Bean
    @ConditionalOnClass(value={Messages.class})
    RestServerExceptionMapper restServerExceptionMapper(Messages messages, @Value(value="${n2o.ui.message.stacktrace}") Boolean canExportStack) {
        return new RestServerExceptionMapper(canExportStack, messages);
    }

    @Bean
    @ConditionalOnClass(value={Messages.class})
    MessageExceptionMapper messageExceptionMapper(Messages messages) {
        return new MessageExceptionMapper(messages);
    }

    @Bean
    @ConditionalOnProperty(value={"management.tracing.enabled"})
    BraveFeature braveFeature(Tracing brave) {
        return new BraveFeature(brave);
    }

    @Bean
    JaxRsAcceptHeaderSorter jaxRsAcceptHeaderSorter() {
        return new JaxRsAcceptHeaderSorter();
    }
}

