/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.n2oapp.platform.jaxrs.TypedParamConverter;

public class DateISOParameterConverter
implements TypedParamConverter<Date> {
    private static final String DATE_FORMAT_PATTERN = "EEE MMM dd HH:mm:ss zzz yyyy";

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    public Date fromString(String value) {
        try {
            return ISO8601Utils.parse((String)value, (ParsePosition)new ParsePosition(0));
        }
        catch (ParseException e) {
            try {
                return new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.ENGLISH).parse(value);
            }
            catch (ParseException e1) {
                throw new IllegalArgumentException("Date [" + value + "] doesn't have ISO format.");
            }
        }
    }

    public String toString(Date value) {
        return ISO8601Utils.format((Date)value);
    }
}

