/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.n2oapp.platform.jaxrs.TypedParamConverter;

public class ListConverter
implements TypedParamConverter<List> {
    private JavaType type;
    private ObjectMapper mapper;

    public ListConverter(Type genericType) {
        this(genericType, null);
    }

    public ListConverter(Type genericType, ObjectMapper mapper) {
        Class valueClass = null;
        valueClass = genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getActualTypeArguments().length > 0 && ((ParameterizedType)genericType).getActualTypeArguments()[0] instanceof Class ? (Class)((ParameterizedType)genericType).getActualTypeArguments()[0] : Object.class;
        this.mapper = mapper != null ? mapper : new ObjectMapper();
        JavaTimeModule jtm = new JavaTimeModule();
        this.mapper.registerModule((Module)jtm);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)new BigDecimalPlainSerializer());
        this.mapper.registerModule((Module)simpleModule);
        this.type = this.mapper.getTypeFactory().constructCollectionType(ArrayList.class, valueClass);
    }

    public List fromString(String value) {
        try {
            return (List)this.mapper.readValue(value, this.type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Failed to convert string '%s' to List", value), e);
        }
    }

    public String toString(List value) {
        try {
            return this.mapper.writeValueAsString((Object)value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to convert from List to string", e);
        }
    }

    @Override
    public Class<List> getType() {
        return List.class;
    }

    public static class BigDecimalPlainSerializer
    extends JsonSerializer<BigDecimal> {
        public void serialize(BigDecimal value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.stripTrailingZeros().toPlainString());
        }

        public void serializeWithType(BigDecimal value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, JsonToken.VALUE_STRING));
            this.serialize(value, gen, null);
            typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, JsonToken.VALUE_STRING));
        }
    }
}

