/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.n2oapp.platform.i18n.Message;
import net.n2oapp.platform.i18n.Messages;
import net.n2oapp.platform.i18n.UserException;
import net.n2oapp.platform.jaxrs.RestExceptionMapper;
import net.n2oapp.platform.jaxrs.RestMessage;

@Provider
public class MessageExceptionMapper
implements RestExceptionMapper<UserException> {
    private Messages messages;

    public MessageExceptionMapper(Messages messages) {
        this.messages = messages;
    }

    @Override
    public RestMessage toMessage(UserException exception) {
        if (exception.getMessages() != null) {
            return new RestMessage(exception.getMessages().stream().map(this::toError).collect(Collectors.toList()));
        }
        return new RestMessage(this.messages.getMessage(exception.getMessage(), exception.getArgs()));
    }

    private RestMessage.Error toError(Message message) {
        return new RestMessage.Error(this.messages.getMessage(message.getCode(), message.getArgs()));
    }

    @Override
    public Response.Status getStatus() {
        return Response.Status.BAD_REQUEST;
    }
}

