/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;

public class RemoteException
extends RuntimeException {
    private static final Pattern STACKTRACE_ELEMENT_PATTERN = Pattern.compile(".+\\(.+:[0-9]+\\)");
    private static final long serialVersionUID = 4938245199690655790L;

    public RemoteException(String[] stackTrace) {
        super(stackTrace[0]);
        this.setStackTrace((StackTraceElement[])Arrays.stream(stackTrace).map(RemoteException::parseFrame).filter(Objects::nonNull).toArray(StackTraceElement[]::new));
    }

    private static StackTraceElement parseFrame(String stackTraceFrame) {
        String frame = stackTraceFrame.replace("\tat ", "").trim();
        if (STACKTRACE_ELEMENT_PATTERN.matcher(frame).matches()) {
            String classAndMethod = frame.substring(0, frame.indexOf(40));
            String fileAndLine = frame.substring(frame.indexOf(40) + 1, frame.length() - 1);
            String className = classAndMethod.substring(0, classAndMethod.lastIndexOf(46));
            String methodName = classAndMethod.substring(classAndMethod.lastIndexOf(46) + 1);
            String fileName = fileAndLine.substring(0, fileAndLine.indexOf(58));
            int lineNumber = Integer.parseInt(fileAndLine.substring(fileAndLine.indexOf(58) + 1));
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        return null;
    }
}

