/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.n2oapp.platform.jaxrs.RestCriteria;
import net.n2oapp.platform.jaxrs.RestPage;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

abstract class SpringDataModule
extends SimpleModule {
    private static final String DIRECTION = "direction";
    private static final String PROPERTY = "property";

    SpringDataModule() {
        super(PackageVersion.VERSION);
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver();
        resolver.addMapping(Pageable.class, RestCriteria.class);
        this.setAbstractTypes(resolver);
        this.setMixInAnnotation(Page.class, PageMixin.class);
    }

    @JacksonXmlRootElement(localName="sort")
    private static class XmlSort {
        private List<XmlOrder> orders;

        private XmlSort() {
        }

        @JsonGetter
        private List<XmlOrder> getOrders() {
            return this.orders;
        }

        @JsonSetter
        private void setOrders(List<XmlOrder> orders) {
            this.orders = orders;
        }

        private static class XmlOrder {
            private String property;
            private String direction;

            private XmlOrder() {
            }

            @JsonGetter
            private String getProperty() {
                return this.property;
            }

            @JsonSetter
            private void setProperty(String property) {
                this.property = property;
            }

            @JsonGetter
            private String getDirection() {
                return this.direction;
            }

            @JsonSetter
            private void setDirection(String direction) {
                this.direction = direction;
            }
        }
    }

    @JsonDeserialize(as=RestPage.class)
    @JacksonXmlRootElement(localName="page")
    @JsonIgnoreProperties(value={"last", "number", "numberOfElements", "size", "totalPages", "first", "pageable", "empty"})
    private static class PageMixin {
        private PageMixin() {
        }
    }

    private static class XmlSortDeserializer
    extends JsonDeserializer<Sort> {
        private XmlSortDeserializer() {
        }

        public Sort deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            XmlSort xmlSort = (XmlSort)p.readValueAs(XmlSort.class);
            return Sort.by(xmlSort.getOrders().stream().map(xmlOrder -> new Sort.Order(Sort.Direction.valueOf((String)xmlOrder.getDirection().toUpperCase()), xmlOrder.getProperty())).collect(Collectors.toList()));
        }
    }

    private static class XmlSortSerializer
    extends StdSerializer<Sort> {
        XmlSortSerializer() {
            super(Sort.class);
        }

        public void serialize(Sort value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            XmlSort xmlSort = new XmlSort();
            xmlSort.setOrders(new ArrayList<XmlSort.XmlOrder>());
            for (Sort.Order order : value) {
                XmlSort.XmlOrder xmlOrder = new XmlSort.XmlOrder();
                xmlOrder.setProperty(order.getProperty());
                xmlOrder.setDirection(order.getDirection().name().toLowerCase());
                xmlSort.getOrders().add(xmlOrder);
            }
            gen.writeObject((Object)xmlSort);
        }
    }

    private static class JsonSortDeserializer
    extends JsonDeserializer<Sort> {
        private JsonSortDeserializer() {
        }

        public Sort deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ArrayNode node = (ArrayNode)jp.getCodec().readTree(jp);
            Sort.Order[] orders = new Sort.Order[node.size()];
            int i = 0;
            for (JsonNode obj : node) {
                Sort.Direction direction = obj.get(SpringDataModule.DIRECTION) != null ? Sort.Direction.valueOf((String)obj.get(SpringDataModule.DIRECTION).asText().toUpperCase()) : null;
                orders[i] = new Sort.Order(direction, obj.get(SpringDataModule.PROPERTY).asText());
                ++i;
            }
            return Sort.by((Sort.Order[])orders);
        }
    }

    private static class JsonSortSerializer
    extends StdSerializer<Sort> {
        private JsonSortSerializer() {
            super(Sort.class);
        }

        public void serialize(Sort value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartArray();
            for (Sort.Order order : value) {
                gen.writeStartObject();
                gen.writeStringField(SpringDataModule.PROPERTY, order.getProperty());
                gen.writeStringField(SpringDataModule.DIRECTION, order.getDirection().name().toLowerCase());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
    }

    static class SpringDataXmlModule
    extends SpringDataModule {
        SpringDataXmlModule() {
            this.addSerializer((JsonSerializer)new XmlSortSerializer());
            this.addDeserializer(Sort.class, new XmlSortDeserializer());
        }
    }

    static class SpringDataJsonModule
    extends SpringDataModule {
        SpringDataJsonModule() {
            this.addSerializer((JsonSerializer)new JsonSortSerializer());
            this.addDeserializer(Sort.class, new JsonSortDeserializer());
        }
    }
}

