/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.n2oapp.platform.jaxrs.RestExceptionMapper;
import net.n2oapp.platform.jaxrs.RestMessage;

@Provider
public class ViolationRestExceptionMapper
implements RestExceptionMapper<ValidationException> {
    @Override
    public RestMessage toMessage(ValidationException exception) {
        if (exception instanceof ConstraintViolationException) {
            Set constraintViolations = ((ConstraintViolationException)exception).getConstraintViolations();
            List<RestMessage.Error> errors = constraintViolations.stream().map(c -> new RestMessage.Error(c.getPropertyPath().toString(), c.getMessage())).collect(Collectors.toList());
            return new RestMessage(errors);
        }
        return new RestMessage(exception.getMessage());
    }

    @Override
    public Response.Status getStatus() {
        return Response.Status.BAD_REQUEST;
    }
}

