/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.time.LocalDateTime;
import java.util.Objects;

public class CodeGenerator {
    private static final int SHIFT_OFFSET = 5;

    public static String generate(String prefix) {
        LocalDateTime dateTime = LocalDateTime.now();
        int yearOffset = dateTime.getYear() - 2021;
        int secondOfDay = 3600 * dateTime.getHour() + 60 * dateTime.getMinute() + dateTime.getSecond();
        int millisecond = dateTime.getNano() / 1000000;
        String uid = secondOfDay + " " + millisecond + " " + yearOffset + dateTime.getDayOfYear();
        char[] intCharArray = uid.toCharArray();
        for (int i = 0; i < intCharArray.length; ++i) {
            if (intCharArray[i] == ' ') continue;
            intCharArray[i] = CodeGenerator.shift(intCharArray[i]);
        }
        if (Objects.nonNull(prefix) && !prefix.isEmpty()) {
            return prefix + " " + String.valueOf(intCharArray);
        }
        return String.valueOf(intCharArray);
    }

    private static char shift(char input) {
        return input + 5 > 57 ? (char)(input + 5 - 10) : (char)(input + 5);
    }

    private CodeGenerator() {
        throw new UnsupportedOperationException();
    }
}

