/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import jakarta.ws.rs.WebApplicationException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.n2oapp.platform.jaxrs.TypedParamConverter;

public class DateParameterConverter
implements TypedParamConverter<Date> {
    private String format;

    public DateParameterConverter(String format) {
        this.format = format;
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    public Date fromString(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public String toString(Date t) {
        return new SimpleDateFormat(this.format).format(t);
    }
}

