/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public abstract class RestCriteria
implements Pageable {
    public static final int FIRST_PAGE_NUMBER = 0;
    public static final int MIN_PAGE_SIZE = 1;
    public static final int DEFAULT_PAGE_NUMBER = 0;
    public static final int DEFAULT_PAGE_SIZE = 10;
    @QueryParam(value="page")
    @DefaultValue(value="0")
    private int pageNumber;
    @QueryParam(value="size")
    @DefaultValue(value="10")
    private int pageSize;
    @QueryParam(value="sort")
    private List<Sort.Order> orders;

    public RestCriteria() {
        this(0, 10);
    }

    public RestCriteria(int pageNumber, int pageSize, Sort sort) {
        this(pageNumber, pageSize);
        this.orders = sort.get().collect(Collectors.toList());
    }

    public RestCriteria(int pageNumber, int pageSize) {
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
    }

    @JsonProperty(value="size")
    public int getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page")
    public int getPageNumber() {
        return this.pageNumber;
    }

    @JsonIgnore
    public long getOffset() {
        return (long)this.pageNumber * (long)this.pageSize;
    }

    @JsonIgnore
    public Sort getSort() {
        if (!CollectionUtils.isEmpty(this.orders)) {
            return Sort.by(this.orders);
        }
        return Sort.by(this.getDefaultOrders());
    }

    protected abstract List<Sort.Order> getDefaultOrders();

    public void setPageNumber(int pageNumber) {
        if (pageNumber < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.pageSize = pageSize;
    }

    public void setOrders(List<Sort.Order> orders) {
        this.orders = orders;
    }

    @JsonIgnore
    public RestCriteria next() {
        return this.constructNew(this.pageNumber + 1, this.pageSize, this.orders);
    }

    @JsonIgnore
    public RestCriteria previous() {
        if (this.pageNumber == 0) {
            throw new IllegalStateException("The beginning reached. Page number is: 0");
        }
        return this.constructNew(this.pageNumber - 1, this.pageSize, this.orders);
    }

    @JsonIgnore
    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    @JsonIgnore
    public RestCriteria previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    @JsonIgnore
    public RestCriteria first() {
        return this.constructNew(0, this.pageSize, this.orders);
    }

    @JsonIgnore
    public boolean isPaged() {
        return true;
    }

    @JsonIgnore
    public boolean isUnpaged() {
        return !this.isPaged();
    }

    private RestCriteria constructNew(int pageNumber, int pageSize, List<Sort.Order> orders) {
        RestCriteria criteria;
        Class<?> c = this.getClass();
        try {
            criteria = (RestCriteria)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Exception occurred while creating criteria of classs: " + c, e);
        }
        criteria.setPageNumber(pageNumber);
        criteria.setPageSize(pageSize);
        criteria.setOrders(orders);
        HashMap fields = new HashMap();
        ReflectionUtils.doWithFields(c, field -> {
            if (this.canSetField(field)) {
                field.setAccessible(true);
                Object param = field.get(this);
                fields.put(field.getName().intern(), param);
            }
        });
        ReflectionUtils.doWithFields(c, field -> {
            if (this.canSetField(field)) {
                field.set(criteria, fields.get(field.getName()));
            }
        });
        return criteria;
    }

    private boolean canSetField(Field field) {
        return field.getDeclaringClass() != RestCriteria.class && !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestCriteria)) {
            return false;
        }
        RestCriteria that = (RestCriteria)o;
        return this.pageNumber == that.pageNumber && this.pageSize == that.pageSize && Objects.equals(this.orders, that.orders);
    }

    public int hashCode() {
        return Objects.hash(this.pageNumber, this.pageSize, this.orders);
    }

    public RestCriteria withPage(int pageNumber) {
        return this.constructNew(pageNumber, this.pageSize, this.orders);
    }
}

