/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class RestMessage
implements Serializable {
    private static final long serialVersionUID = 139886274946702785L;
    private String message;
    private List<? extends BaseError> errors;
    private String[] stackTrace;

    public RestMessage(List<? extends BaseError> errors) {
        this.errors = errors;
    }

    public RestMessage(String message) {
        this.message = message;
    }

    public RestMessage() {
    }

    public String getMessage() {
        return this.message;
    }

    public List<? extends BaseError> getErrors() {
        return this.errors;
    }

    public String[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public static class ConstraintViolationError
    extends BaseError {
        private static final long serialVersionUID = -1337L;
        private String field;
        private String leafBeanClass;
        private String rootBeanClass;
        private String constraintAnnotation;

        public ConstraintViolationError() {
        }

        public ConstraintViolationError(String message, String field, String leafBeanClass, String rootBeanClass, String constraintAnnotation) {
            super(message);
            this.field = field;
            this.leafBeanClass = leafBeanClass;
            this.rootBeanClass = rootBeanClass;
            this.constraintAnnotation = constraintAnnotation;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getLeafBeanClass() {
            return this.leafBeanClass;
        }

        public void setLeafBeanClass(String leafBeanClass) {
            this.leafBeanClass = leafBeanClass;
        }

        public String getRootBeanClass() {
            return this.rootBeanClass;
        }

        public void setRootBeanClass(String rootBeanClass) {
            this.rootBeanClass = rootBeanClass;
        }

        public String getConstraintAnnotation() {
            return this.constraintAnnotation;
        }

        public void setConstraintAnnotation(String constraintAnnotation) {
            this.constraintAnnotation = constraintAnnotation;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConstraintViolationError that = (ConstraintViolationError)o;
            return Objects.equals(this.getField(), that.getField()) && Objects.equals(this.getLeafBeanClass(), that.getLeafBeanClass()) && Objects.equals(this.getRootBeanClass(), that.getRootBeanClass()) && Objects.equals(this.getConstraintAnnotation(), that.getConstraintAnnotation());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getField(), this.getLeafBeanClass(), this.getRootBeanClass(), this.getConstraintAnnotation());
        }
    }

    public static class Error
    extends BaseError {
        public Error() {
        }

        public Error(String message) {
            super(message);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="t")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Error.class, name="1"), @JsonSubTypes.Type(value=ConstraintViolationError.class, name="2")})
    public static abstract class BaseError
    implements Serializable {
        private static final long serialVersionUID = -6241752723478340674L;
        private String message;

        public BaseError() {
        }

        public BaseError(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseError error = (BaseError)o;
            return Objects.equals(this.getMessage(), error.getMessage());
        }

        public int hashCode() {
            return Objects.hash(this.getMessage());
        }
    }
}

