/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.n2oapp.platform.jaxrs.OrderParameterConverter;
import net.n2oapp.platform.jaxrs.TypedParamConverter;
import org.springframework.data.domain.Sort;

public class SortParameterConverter
implements TypedParamConverter<Sort> {
    private final OrderParameterConverter orderConverter = new OrderParameterConverter();

    @Override
    public Class<Sort> getType() {
        return Sort.class;
    }

    public Sort fromString(String value) {
        if (value == null || value.isBlank()) {
            return Sort.unsorted();
        }
        return Sort.by(Arrays.stream(value.split(",")).map(this.orderConverter::fromString).collect(Collectors.toList()));
    }

    public String toString(Sort value) {
        return value.stream().map(this.orderConverter::toString).collect(Collectors.joining(","));
    }
}

