/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Set;
import net.n2oapp.platform.jaxrs.RestExceptionMapper;
import net.n2oapp.platform.jaxrs.RestMessage;

@Provider
public class ViolationRestExceptionMapper
implements RestExceptionMapper<ValidationException> {
    @Override
    public RestMessage toMessage(ValidationException exception) {
        if (exception instanceof ConstraintViolationException) {
            Set constraintViolations = ((ConstraintViolationException)exception).getConstraintViolations();
            ArrayList<RestMessage.ConstraintViolationError> errors = new ArrayList<RestMessage.ConstraintViolationError>();
            for (ConstraintViolation c : constraintViolations) {
                RestMessage.ConstraintViolationError constraintViolationError = new RestMessage.ConstraintViolationError(c.getMessage(), c.getPropertyPath().toString(), c.getLeafBean() == null ? null : c.getLeafBean().getClass().getName(), c.getRootBeanClass().getName(), c.getConstraintDescriptor().getAnnotation().annotationType().getName());
                errors.add(constraintViolationError);
            }
            return new RestMessage(errors);
        }
        return new RestMessage(exception.getMessage());
    }

    @Override
    public Response.Status getStatus() {
        return Response.Status.BAD_REQUEST;
    }
}

