/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.jaxrs.seek;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.platform.jaxrs.seek.SeekedPage;
import org.springframework.lang.NonNull;

public class SeekedPageImpl<T>
implements SeekedPage<T> {
    static final SeekedPage<?> EMPTY = new SeekedPageImpl(Collections.emptyList(), false, false);
    private final List<T> content;
    private final boolean hasNext;
    private final boolean hasPrev;

    @JsonCreator
    protected SeekedPageImpl(@JsonProperty(value="content") List<T> content, @JsonProperty(value="hasNext") boolean hasNext, @JsonProperty(value="hasPrev") boolean hasPrev) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        this.content = content;
        this.hasNext = hasNext;
        this.hasPrev = hasPrev;
    }

    @Override
    public List<T> getContent() {
        return this.content;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean hasPrev() {
        return this.hasPrev;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @NonNull
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public ListIterator<T> listIterator() {
        return this.content.listIterator();
    }

    public ListIterator<T> listIteratorFromTheEnd() {
        return this.listIterator(this.content.size());
    }

    public ListIterator<T> listIterator(int idx) {
        return this.content.listIterator(idx);
    }

    @NonNull
    public <E> SeekedPage<E> map(@NonNull Function<? super T, ? extends E> mapper) {
        return SeekedPageImpl.of(this.content.stream().map(mapper).collect(Collectors.toList()), this.hasNext, this.hasPrev);
    }

    @NonNull
    public List<T> toList() {
        return this.content;
    }

    @NonNull
    public Set<T> toSet() {
        return new HashSet<T>(this.content);
    }

    @NonNull
    public Stream<T> stream() {
        return this.get();
    }

    @NonNull
    public Stream<T> get() {
        return this.content.stream();
    }

    @NonNull
    public SeekedPage<T> filter(@NonNull Predicate<? super T> predicate) {
        return SeekedPageImpl.of(this.content.stream().filter(predicate).collect(Collectors.toList()), this.hasNext, this.hasPrev);
    }

    @NonNull
    public <R> SeekedPage<R> flatMap(@NonNull Function<? super T, ? extends Stream<? extends R>> mapper) {
        return SeekedPageImpl.of(this.content.stream().flatMap(mapper).collect(Collectors.toList()), this.hasNext, this.hasPrev);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SeekedPageImpl)) {
            return false;
        }
        SeekedPageImpl that = (SeekedPageImpl)o;
        return this.hasNext == that.hasNext && this.hasPrev == that.hasPrev && this.content.equals(that.content);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.hasNext, this.hasPrev);
    }

    public String toString() {
        return "SeekedPage{content=" + this.content + ", hasNext=" + this.hasNext + ", hasPrev=" + this.hasPrev + "}";
    }

    public static <T> SeekedPageImpl<T> of(List<T> content, boolean hasNext, boolean hasPrev) {
        return new SeekedPageImpl<T>(content, hasNext, hasPrev);
    }
}

