/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.test;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortFinder {
    private static final Logger logger = LoggerFactory.getLogger(PortFinder.class);
    private static final int MIN_PORT_NUMBER = 49152;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int ATTEMPTS_LIMIT = 10;

    private PortFinder() {
    }

    public static int getPort(String applicationName) {
        int unusedPort = PortFinder.getUnusedPort();
        logger.info("Find unused port {} for application {}", (Object)unusedPort, (Object)applicationName);
        return unusedPort;
    }

    private static int getUnusedPort() {
        int startPort = PortFinder.getRandomPort();
        int attemptsCount = 1;
        while (!PortFinder.available(startPort)) {
            if (attemptsCount++ > 10) {
                throw new IllegalStateException("Attempts limit exceeded");
            }
            startPort = PortFinder.getRandomPort();
        }
        return startPort;
    }

    private static int getRandomPort() {
        return ThreadLocalRandom.current().nextInt(49152, 65535);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean available(int port) {
        try (ServerSocket ss = new ServerSocket(port);){
            DatagramSocket ds = new DatagramSocket(port);
            try {
                ss.setReuseAddress(true);
                ds.setReuseAddress(true);
                boolean bl = true;
                ds.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    ds.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.info("\u0421an not use port: {}", (Object)port, (Object)e);
            return false;
        }
    }
}

