/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.test.autoconfigure;

import java.util.Properties;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class TestBootstrapPropertiesApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final String CONSUL_PROPERTIES_NAME = "testDefaultConsulProperties";

    public int getOrder() {
        return -2147483640;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        MutablePropertySources propertySources = event.getEnvironment().getPropertySources();
        if (!propertySources.contains(CONSUL_PROPERTIES_NAME)) {
            propertySources.addLast((PropertySource)new PropertiesPropertySource(CONSUL_PROPERTIES_NAME, this.testDefaultConsulProperties()));
        }
    }

    private Properties testDefaultConsulProperties() {
        Properties props = new Properties();
        props.put("spring.config.import", "");
        props.put("spring.cloud.consul.enabled", "false");
        return props;
    }
}

