/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.web.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.data.QueryExceptionHandler;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.exception.N2oUserException;
import net.n2oapp.framework.api.exception.ValidationMessage;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.engine.data.N2oOperationExceptionHandler;
import net.n2oapp.platform.i18n.Messages;
import net.n2oapp.platform.i18n.UserException;
import net.n2oapp.platform.jaxrs.RestException;
import net.n2oapp.platform.jaxrs.RestMessage;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.HttpStatusCodeException;

public class PlatformExceptionHandler
extends N2oOperationExceptionHandler
implements QueryExceptionHandler {
    private Messages messages;
    private ObjectMapper objectMapper = new ObjectMapper();

    public N2oException handle(CompiledObject.Operation operation, DataSet dataSet, Exception e) {
        if (this.isMultipleErrorsException(e)) {
            return this.handleMultipleErrorsException(operation, e);
        }
        N2oException exception = this.handle(e);
        if (exception != null) {
            return exception;
        }
        return super.handle(operation, dataSet, e);
    }

    public N2oException handle(CompiledQuery compiledQuery, N2oPreparedCriteria n2oPreparedCriteria, Exception e) {
        if (this.isMultipleErrorsException(e)) {
            return this.handleMultipleErrorsException(((RestException)e.getCause()).getErrors());
        }
        N2oException exception = this.handle(e);
        if (exception != null) {
            return exception;
        }
        if (e instanceof N2oException) {
            N2oException n2oException = (N2oException)e;
            return n2oException;
        }
        return new N2oException((Throwable)e);
    }

    void setMessages(Messages messages) {
        this.messages = messages;
    }

    void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private N2oException handle(Exception e) {
        N2oException handled = this.handleJaxRsException(e);
        if (handled != null) {
            return handled;
        }
        handled = this.handleRestClientException(e);
        if (handled != null) {
            return handled;
        }
        return this.handleUserException(e);
    }

    private N2oException handleJaxRsException(Exception e) {
        RestException jaxRsException = this.unwrapEx(e, RestException.class);
        if (jaxRsException != null) {
            if (jaxRsException.getResponseStatus() >= 400 && jaxRsException.getResponseStatus() < 500) {
                return new N2oUserException(jaxRsException.getMessage());
            }
            return new N2oException((Throwable)jaxRsException);
        }
        return null;
    }

    private N2oException handleUserException(Exception e) {
        UserException userException = this.unwrapEx(e, UserException.class);
        return userException != null ? new N2oUserException(this.getMessage(userException)) : null;
    }

    private String getMessage(UserException userException) {
        if (this.messages != null) {
            return userException.getArgs() == null ? this.messages.getMessage(userException.getMessage(), new Object[0]) : this.messages.getMessage(userException.getMessage(), userException.getArgs());
        }
        return userException.getMessage();
    }

    private N2oException handleRestClientException(Exception e) {
        HttpStatusCodeException restClientException = this.unwrapEx(e, HttpStatusCodeException.class);
        if (restClientException != null) {
            RestMessage message;
            try {
                message = (RestMessage)this.objectMapper.readValue(restClientException.getResponseBodyAsByteArray(), RestMessage.class);
            }
            catch (IOException e1) {
                N2oException n2oException = new N2oException((Throwable)e);
                n2oException.addSuppressed((Throwable)e1);
                return n2oException;
            }
            if (restClientException.getStatusCode().is4xxClientError() && message != null) {
                return CollectionUtils.isEmpty((Collection)message.getErrors()) ? new N2oUserException(message.getMessage()) : this.handleMultipleErrorsException(message.getErrors());
            }
            if (restClientException.getStatusCode().is5xxServerError() && message != null) {
                return new N2oException((Throwable)new RestException(message, restClientException.getStatusCode().value()));
            }
        }
        return null;
    }

    private <T extends Exception> T unwrapEx(Throwable e, Class<T> exClass) {
        if (exClass.isAssignableFrom(e.getClass())) {
            return (T)((Exception)e);
        }
        if (e.getCause() != null) {
            return this.unwrapEx(e.getCause(), exClass);
        }
        return null;
    }

    private boolean isMultipleErrorsException(Exception e) {
        Throwable throwable;
        if (e instanceof N2oException && (throwable = e.getCause()) instanceof RestException) {
            RestException restException = (RestException)throwable;
            return restException.getErrors() != null;
        }
        return false;
    }

    private N2oException handleMultipleErrorsException(List<? extends RestMessage.BaseError> errors) {
        String message = IntStream.rangeClosed(1, errors.size()).mapToObj(i -> i + ") " + ((RestMessage.BaseError)errors.get(i - 1)).getMessage()).collect(Collectors.joining("\n"));
        return new N2oUserException(message);
    }

    private N2oException handleMultipleErrorsException(CompiledObject.Operation operation, Exception e) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        StringBuilder message = new StringBuilder();
        Map<String, String> fieldIdByValidationFailKey = operation.getInParametersMap().entrySet().stream().filter(entry -> {
            ObjectSimpleField objectSimpleField;
            Object patt6482$temp = entry.getValue();
            return patt6482$temp instanceof ObjectSimpleField && (objectSimpleField = (ObjectSimpleField)patt6482$temp).getValidationFailKey() != null;
        }).collect(Collectors.toMap(entry -> ((ObjectSimpleField)entry.getValue()).getValidationFailKey(), Map.Entry::getKey));
        int counter = 1;
        for (RestMessage.BaseError error : ((RestException)e.getCause()).getErrors()) {
            if (error instanceof RestMessage.ConstraintViolationError) {
                RestMessage.ConstraintViolationError constraintViolationError = (RestMessage.ConstraintViolationError)error;
                validationMessages.add(new ValidationMessage(error.getMessage(), fieldIdByValidationFailKey.get(constraintViolationError.getField()), null));
                continue;
            }
            message.append(counter++).append(") ").append(error.getMessage()).append("\n");
        }
        return validationMessages.isEmpty() ? new N2oUserException(message.toString()) : new N2oUserException(message.toString(), null, validationMessages);
    }
}

