/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.platform.web.autoconfigure;

import java.util.List;
import net.n2oapp.framework.api.rest.RestLoggingHandler;
import net.n2oapp.framework.boot.N2oFrameworkAutoConfiguration;
import net.n2oapp.framework.boot.ObjectMapperConstructor;
import net.n2oapp.framework.engine.data.rest.SpringRestDataProviderEngine;
import net.n2oapp.platform.i18n.Messages;
import net.n2oapp.platform.web.autoconfigure.PlatformExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@AutoConfigureBefore(value={N2oFrameworkAutoConfiguration.class})
@PropertySource(value={"classpath:web.n2o.default.properties"})
public class WebAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public PlatformExceptionHandler platformOperationExceptionHandler(@Autowired(required=false) Messages messages) {
        PlatformExceptionHandler platformExceptionHandler = new PlatformExceptionHandler();
        if (messages != null) {
            platformExceptionHandler.setMessages(messages);
        }
        return platformExceptionHandler;
    }

    @Configuration
    @ConditionalOnClass(name={"net.n2oapp.platform.userinfo.config.InterceptorConfig"})
    public static class RestConfiguration {
        @Bean(value={"restDataProviderEngine"})
        @ConditionalOnMissingBean(name={"restDataProviderEngine"})
        public SpringRestDataProviderEngine oauthRestDataProviderEngine(@Qualifier(value="platformRestTemplate") RestTemplate restTemplate, @Value(value="${n2o.engine.rest.url}") String baseRestUrl, List<RestLoggingHandler> loggingHandlers) {
            SpringRestDataProviderEngine springRestDataProviderEngine = new SpringRestDataProviderEngine(restTemplate, ObjectMapperConstructor.dataObjectMapper(), loggingHandlers);
            springRestDataProviderEngine.setBaseRestUrl(baseRestUrl);
            return springRestDataProviderEngine;
        }
    }
}

