/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.properties.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PropertiesInfoCollector {
    private static final String GROUP_PREFIX = "##";
    private static final String NAME_PREFIX = "#";
    private final String locationPattern;
    private final String encode;
    private Map<String, List<PropertyInfo>> data;
    private final AtomicBoolean init = new AtomicBoolean(false);

    public PropertiesInfoCollector(String locationPattern) {
        this.locationPattern = locationPattern;
        this.encode = "UTF-8";
    }

    public PropertiesInfoCollector(String encode, String locationPattern) {
        this.encode = encode;
        this.locationPattern = locationPattern;
    }

    public Map<String, List<PropertyInfo>> getPropertyInfoMap() {
        this.lazyInit();
        return this.data;
    }

    public String getGroup(String property) {
        return this.getPropertyInfoMap().entrySet().stream().filter(e -> ((List)e.getValue()).stream().filter(p -> p.key.equals(property)).findFirst().isPresent()).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public PropertyInfo getInfo(String group, String key) {
        return group != null ? this.getPropertyInfoMap().getOrDefault(group, Collections.emptyList()).stream().filter(info -> info.key.equals(key)).findFirst().orElseGet(() -> new PropertyInfo(key)) : new PropertyInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (!this.init.get()) {
            AtomicBoolean atomicBoolean = this.init;
            synchronized (atomicBoolean) {
                if (!this.init.get()) {
                    try {
                        this.data = this.calculate();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    this.init.set(true);
                }
            }
        }
    }

    private Map<String, List<PropertyInfo>> calculate() throws IOException {
        HashMap<String, List> propertyMap = new HashMap<String, List>();
        PathMatchingResourcePatternResolver pathPatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = pathPatternResolver.getResources(this.locationPattern);
        if (resources == null || resources.length == 0) {
            return Collections.unmodifiableMap(new HashMap());
        }
        Arrays.stream(resources).map(this::retrieve).forEach(file -> {
            String[] group = new String[]{""};
            String[] name = new String[]{null};
            String[] description = new String[]{""};
            file.forEach(str -> {
                for (String line : str.split("\n")) {
                    if ((line = this.clean(line)).isEmpty()) continue;
                    if (this.isGroup(line)) {
                        group[0] = line.replaceFirst(GROUP_PREFIX, "").trim();
                        continue;
                    }
                    if (name[0] == null && this.isNameOrDescription(line)) {
                        name[0] = line;
                        continue;
                    }
                    if (name[0] != null && this.isNameOrDescription(line)) {
                        description[0] = description[0].concat(line).concat("\n");
                        continue;
                    }
                    propertyMap.computeIfAbsent(group[0], key -> new ArrayList()).add(new PropertyInfo(this.getKey(line), group[0], name[0], description[0]));
                    name[0] = null;
                    description[0] = "";
                }
            });
        });
        ConcurrentHashMap propertyMapNotModified = new ConcurrentHashMap();
        propertyMap.forEach((k, v) -> propertyMapNotModified.put(k, Collections.unmodifiableList(v)));
        return Collections.unmodifiableMap(propertyMapNotModified);
    }

    private List<String> retrieve(Resource resource) {
        ArrayList<String> arrayList;
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), this.encode));
        try {
            String str;
            ArrayList<String> lines = new ArrayList<String>();
            while ((str = reader.readLine()) != null) {
                lines.add(str.concat("\n"));
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    private boolean isGroup(String str) {
        return str.startsWith(GROUP_PREFIX);
    }

    private boolean isNameOrDescription(String str) {
        return str.startsWith(NAME_PREFIX);
    }

    private String getKey(String str) {
        return str.split("[\\s=]")[0];
    }

    private String clean(String str) {
        return str.replaceFirst("\\s*", "");
    }

    public static class PropertyInfo {
        public final String key;
        public final String group;
        public final String name;
        public final String description;

        public PropertyInfo(String key) {
            this.key = key;
            this.group = null;
            this.name = null;
            this.description = null;
        }

        public PropertyInfo(String key, String group, String name, String description) {
            this.key = key;
            this.group = group;
            this.name = name != null ? name.replaceFirst(PropertiesInfoCollector.NAME_PREFIX, "").trim() : null;
            this.description = description != null && !description.isEmpty() ? description.replaceFirst(PropertiesInfoCollector.NAME_PREFIX, "").replaceAll("\\n#", "\n").replaceAll("\\s+", " ").trim() : null;
        }
    }
}

