/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.acceptance;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.nemerosa.ontrack.client.ClientValidationException;
import net.nemerosa.ontrack.client.JsonClient;
import net.nemerosa.ontrack.client.JsonClientImpl;
import net.nemerosa.ontrack.client.OTHttpClient;
import net.nemerosa.ontrack.client.OTHttpClientBuilder;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.test.TestUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;

public abstract class AcceptanceSupport {
    private static final ObjectMapper mapper = ObjectMapperFactory.create();

    @Before
    public void waitForApplication() {
        System.out.format("Check for application readiness at %s%n", this.getBaseURL());
    }

    public JsonNode nameDescription() {
        return JsonUtils.object().with("name", TestUtils.uid((String)"")).with("description", TestUtils.uid((String)"")).end();
    }

    public static String env(String property, boolean required, String defaultValue, String name) {
        String sys = System.getProperty(property);
        if (StringUtils.isNotBlank((CharSequence)sys)) {
            return sys;
        }
        String envName = property.toUpperCase().replace(".", "_");
        String env = System.getenv(envName);
        if (StringUtils.isNotBlank((CharSequence)env)) {
            return env;
        }
        if (required) {
            throw new IllegalStateException(String.format("The %s system property or %s environment variable is required (%s)", property, envName, name));
        }
        return defaultValue;
    }

    protected Client anonymous() {
        return this.client(() -> this.clientBuilder().build());
    }

    protected Client admin() {
        String adminPassword = this.getAdminPassword();
        return this.client(() -> this.clientBuilder().withCredentials("admin", adminPassword).build());
    }

    protected String getAdminPassword() {
        return AcceptanceSupport.env("ontrack.admin", false, "admin", "Acceptance admin password");
    }

    private OTHttpClientBuilder clientBuilder() {
        boolean disableSSL = this.isSslDisabled();
        return OTHttpClientBuilder.create((String)this.getBaseURL(), (boolean)disableSSL);
    }

    protected boolean isSslDisabled() {
        return "true".equals(AcceptanceSupport.env("ontrack.disableSSL", false, "false", "Disabling SSL checks"));
    }

    protected String getBaseURL() {
        return AcceptanceSupport.env("ontrack.url", true, null, "Base URL for the application to test");
    }

    private Client client(Supplier<OTHttpClient> otHttpClientSupplier) {
        JsonClientImpl jsonClient = new JsonClientImpl(otHttpClientSupplier.get());
        return new Client((JsonClient)jsonClient){
            final /* synthetic */ JsonClient val$jsonClient;
            {
                this.val$jsonClient = jsonClient;
            }

            @Override
            public JsonResult get(String path, Object ... parameters) {
                return new SimpleJsonResult(this.val$jsonClient.get(path, parameters));
            }

            @Override
            public JsonResult delete(String path, Object ... parameters) {
                return new SimpleJsonResult(this.val$jsonClient.delete(path, parameters));
            }

            @Override
            public JsonResult post(Object data, String path, Object ... parameters) {
                return new SimpleJsonResult(this.val$jsonClient.post(data, path, parameters));
            }

            @Override
            public JsonResult put(Object data, String path, Object ... parameters) {
                return new SimpleJsonResult(this.val$jsonClient.put(data, path, parameters));
            }
        };
    }

    protected void validationMessage(Runnable task, String expectedMessage) throws IOException {
        try {
            task.run();
            Assert.fail((String)"The call should have failed with a validation exception.");
        }
        catch (ClientValidationException ex) {
            JsonNode error = mapper.readTree(ex.getMessage());
            Assert.assertEquals((Object)expectedMessage, (Object)error.path("message").asText());
        }
    }

    protected static class SimpleJsonResult
    implements JsonResult {
        private final JsonNode node;

        public SimpleJsonResult(JsonNode node) {
            this.node = node;
        }

        @Override
        public JsonNode get() {
            return this.node;
        }

        @Override
        public Consumer<JsonNode> withNode(Consumer<JsonNode> consumer) {
            consumer.accept(this.node);
            return consumer;
        }
    }

    protected static interface JsonResult {
        public JsonNode get();

        public Consumer<JsonNode> withNode(Consumer<JsonNode> var1);
    }

    protected static interface Client {
        public JsonResult get(String var1, Object ... var2);

        public JsonResult delete(String var1, Object ... var2);

        public JsonResult post(Object var1, String var2, Object ... var3);

        public JsonResult put(Object var1, String var2, Object ... var3);
    }
}

