/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.acceptance.boot;

import net.nemerosa.ontrack.acceptance.boot.AcceptanceConfig;
import net.nemerosa.ontrack.acceptance.boot.JUnitAcceptanceRunner;
import net.nemerosa.ontrack.acceptance.support.AcceptanceTest;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptanceTestRunner
extends BlockJUnit4ClassRunner {
    private final Logger logger = LoggerFactory.getLogger(JUnitAcceptanceRunner.class);
    private AcceptanceConfig config;

    public AcceptanceTestRunner(Class<?> klass, AcceptanceConfig config) throws InitializationError {
        super(klass);
        this.config = config;
    }

    public void run(RunNotifier notifier) {
        this.logger.info("\n\n[TESTSUITE] " + this.getDescription() + "\n");
        super.run(notifier);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        AcceptanceTest acceptanceTest = (AcceptanceTest)method.getAnnotation(AcceptanceTest.class);
        if (!this.config.acceptTest(acceptanceTest)) {
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        this.logger.info("\n\n[TEST] " + this.describeChild(method) + "\n");
        super.runChild(method, notifier);
    }
}

