/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.acceptance;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Supplier;
import net.nemerosa.ontrack.acceptance.AcceptanceSupport;
import net.nemerosa.ontrack.acceptance.config.AcceptanceConfigRule;
import net.nemerosa.ontrack.client.ClientValidationException;
import net.nemerosa.ontrack.client.JsonClientImpl;
import net.nemerosa.ontrack.client.OTHttpClient;
import net.nemerosa.ontrack.client.OTHttpClientBuilder;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class AcceptanceSupport {
    private static final ObjectMapper mapper = ObjectMapperFactory.create();
    @Rule
    public AcceptanceConfigRule configRule = new AcceptanceConfigRule();

    @Before
    public void waitForApplication() {
        System.out.format("Check for application readiness at %s%n", this.getBaseURL());
    }

    public JsonNode nameDescription() {
        return JsonUtils.object().with("name", TestUtils.uid((String)"")).with("description", TestUtils.uid((String)"")).end();
    }

    protected Client anonymous() {
        return this.client(() -> this.clientBuilder().build());
    }

    protected Client admin() {
        String adminPassword = this.getAdminPassword();
        return this.client(() -> this.clientBuilder().withCredentials("admin", adminPassword).build());
    }

    protected String getAdminPassword() {
        return this.configRule.getConfig().getAdmin();
    }

    private OTHttpClientBuilder clientBuilder() {
        boolean disableSsl = this.isSslDisabled();
        return OTHttpClientBuilder.create((String)this.getBaseURL(), (boolean)disableSsl);
    }

    protected boolean isSslDisabled() {
        return this.configRule.getConfig().isDisableSsl();
    }

    protected String getBaseURL() {
        return this.configRule.getConfig().getUrl();
    }

    private Client client(Supplier<OTHttpClient> otHttpClientSupplier) {
        JsonClientImpl jsonClient = new JsonClientImpl(otHttpClientSupplier.get());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void validationMessage(Runnable task, String expectedMessage) throws IOException {
        try {
            task.run();
            Assert.fail((String)"The call should have failed with a validation exception.");
        }
        catch (ClientValidationException ex) {
            JsonNode error = mapper.readTree(ex.getMessage());
            Assert.assertEquals((Object)expectedMessage, (Object)error.path("message").asText());
        }
    }
}

